/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.init.ModKeybindings;

public class SSetServerMaxBarsPacket {
    private int bars;

    public SSetServerMaxBarsPacket() {
    }

    public SSetServerMaxBarsPacket(int bars) {
        this.bars = bars;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.bars);
    }

    public static SSetServerMaxBarsPacket decode(PacketBuffer buffer) {
        SSetServerMaxBarsPacket msg = new SSetServerMaxBarsPacket();
        msg.bars = buffer.readInt();
        return msg;
    }

    public static void handle(SSetServerMaxBarsPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSetServerMaxBarsPacket message) {
            ModKeybindings.serverMaxBars = message.bars;
        }
    }
}

