/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class SCarryEntityPacket {
    private int targetId;

    public SCarryEntityPacket() {
    }

    public SCarryEntityPacket(@Nullable LivingEntity target) {
        this.targetId = target != null ? target.func_145782_y() : -1;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.targetId);
    }

    public static SCarryEntityPacket decode(PacketBuffer buffer) {
        SCarryEntityPacket msg = new SCarryEntityPacket();
        msg.targetId = buffer.readInt();
        return msg;
    }

    public static void handle(SCarryEntityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SCarryEntityPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player == null) {
                return;
            }
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            int targetId = message.targetId;
            if (targetId >= 0) {
                Entity entity = mc.field_71441_e.func_73045_a(message.targetId);
                if (entity == null || !(entity instanceof LivingEntity)) {
                    props.stopCarrying();
                    return;
                }
                LivingEntity living = (LivingEntity)entity;
                props.startCarrying(living);
            } else {
                props.stopCarrying();
            }
        }
    }
}

