/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ui;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.interactions.Interaction;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SCloseScreenPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.STriggerInteractionPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CTriggerInteractionPacket {
    private Interaction interaction;
    private int entityId;

    public CTriggerInteractionPacket() {
    }

    public CTriggerInteractionPacket(Interaction interaction, LivingEntity entity) {
        this.interaction = interaction;
        this.entityId = entity.func_145782_y();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.interaction != null);
        if (this.interaction != null) {
            buffer.func_192572_a(this.interaction.getRegistryName());
        }
    }

    public static CTriggerInteractionPacket decode(PacketBuffer buffer) {
        CTriggerInteractionPacket msg = new CTriggerInteractionPacket();
        msg.entityId = buffer.readInt();
        boolean hasInteraction = buffer.readBoolean();
        if (hasInteraction) {
            ResourceLocation res = buffer.func_192575_l();
            msg.interaction = (Interaction)ModRegistries.INTERACTIONS.getValue(res);
        }
        return msg;
    }

    public static void handle(CTriggerInteractionPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity entity = player.field_70170_p.func_73045_a(message.entityId);
                if (!(entity instanceof LivingEntity)) {
                    return;
                }
                LivingEntity living = (LivingEntity)entity;
                if (message.interaction == null) {
                    return;
                }
                Interaction.InteractionResult result = message.interaction.trigger((PlayerEntity)player, living);
                if (result.getType() == Interaction.InteractionResultType.CONTINUE) {
                    WyNetwork.sendTo(new STriggerInteractionPacket(message.interaction), (PlayerEntity)player);
                } else if (result.getType() == Interaction.InteractionResultType.NEXT) {
                    WyNetwork.sendTo(new STriggerInteractionPacket(result.getNextInteraction()), (PlayerEntity)player);
                } else if (result.getType() == Interaction.InteractionResultType.CLOSE_DIALOGUE) {
                    WyNetwork.sendTo(new SCloseScreenPacket(), (PlayerEntity)player);
                }
            });
        }
    }
}

