/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ofpw;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.OneFruitEntry;
import xyz.pixelatedw.mineminenomi.data.world.OFPWWorldData;

public class CRequestCreativeDeleteOFPWPacket {
    private ResourceLocation fruitId;

    public CRequestCreativeDeleteOFPWPacket() {
    }

    public CRequestCreativeDeleteOFPWPacket(ResourceLocation fruitId) {
        this.fruitId = fruitId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.fruitId);
    }

    public static CRequestCreativeDeleteOFPWPacket decode(PacketBuffer buffer) {
        CRequestCreativeDeleteOFPWPacket msg = new CRequestCreativeDeleteOFPWPacket();
        msg.fruitId = buffer.func_192575_l();
        return msg;
    }

    public static void handle(CRequestCreativeDeleteOFPWPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                OFPWWorldData worldProps = OFPWWorldData.get();
                if (!player.func_184812_l_() || !player.func_211513_k(2)) {
                    return;
                }
                OneFruitEntry entry = worldProps.getOneFruitEntry(message.fruitId);
                if (entry != null) {
                    boolean isSenderOwner;
                    boolean bl = isSenderOwner = entry.getOwner().isPresent() && entry.getOwner().get().equals(player.func_110124_au());
                    if (entry.getStatus() != OneFruitEntry.Status.INVENTORY || !isSenderOwner) {
                        return;
                    }
                }
                worldProps.lostOneFruit(message.fruitId, (LivingEntity)player, "Deleted using creative inventory");
            });
        }
    }
}

