/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.entity;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effects;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CDoctorHealPacket {
    private int entityId;

    public CDoctorHealPacket() {
    }

    public CDoctorHealPacket(int entityId) {
        this.entityId = entityId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
    }

    public static CDoctorHealPacket decode(PacketBuffer buffer) {
        CDoctorHealPacket msg = new CDoctorHealPacket();
        msg.entityId = buffer.readInt();
        return msg;
    }

    public static void handle(CDoctorHealPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
                int payment = (int)(player.func_110138_aP() - player.func_110143_aJ()) * 10;
                if (props.getBelly() < (long)payment) {
                    return;
                }
                if (WyHelper.isInCombat((LivingEntity)player)) {
                    return;
                }
                props.alterBelly(-payment, StatChangeSource.STORE);
                player.func_70691_i(player.func_110138_aP());
                player.func_195063_d(Effects.field_76436_u);
                WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), (PlayerEntity)player);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

