/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.ability;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PauseTickComponent;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SSetPauseTickPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CTogglePassiveAbilityPacket {
    private ResourceLocation abilityKey;

    public CTogglePassiveAbilityPacket() {
    }

    public CTogglePassiveAbilityPacket(AbilityCore ability) {
        this.abilityKey = ability.getRegistryName();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.abilityKey);
    }

    public static CTogglePassiveAbilityPacket decode(PacketBuffer buffer) {
        CTogglePassiveAbilityPacket msg = new CTogglePassiveAbilityPacket();
        msg.abilityKey = buffer.func_192575_l();
        return msg;
    }

    public static void handle(CTogglePassiveAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
                AbilityCore core = (AbilityCore)ModRegistries.ABILITIES.getValue(message.abilityKey);
                if (core == null || core.getType() != AbilityType.PASSIVE) {
                    return;
                }
                Object ability = abilityDataProps.getPassiveAbility(core);
                if (ability == null) {
                    return;
                }
                ability.getComponent(ModAbilityKeys.PAUSE_TICK).ifPresent(arg_0 -> CTogglePassiveAbilityPacket.lambda$null$0((PlayerEntity)player, core, arg_0));
            });
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(PlayerEntity player, AbilityCore core, PauseTickComponent comp) {
        comp.setPause((LivingEntity)player, !comp.isPaused());
        WyNetwork.sendToAllTrackingAndSelf(new SSetPauseTickPacket((LivingEntity)player, core, comp.isPaused()), (Entity)player);
    }
}

