/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenAbilitySelectionScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CRequestSyncAbilityDataPacket {
    private boolean openScreen;

    public CRequestSyncAbilityDataPacket() {
    }

    public CRequestSyncAbilityDataPacket(boolean openScreen) {
        this.openScreen = openScreen;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.openScreen);
    }

    public static CRequestSyncAbilityDataPacket decode(PacketBuffer buffer) {
        CRequestSyncAbilityDataPacket msg = new CRequestSyncAbilityDataPacket();
        msg.openScreen = buffer.readBoolean();
        return msg;
    }

    public static void handle(CRequestSyncAbilityDataPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
                WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
                if (message.openScreen) {
                    WyNetwork.sendTo(new SOpenAbilitySelectionScreenPacket(CommonConfig.INSTANCE.getAbilityBars()), (PlayerEntity)player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

