/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.models.entities.mobs.animals;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunctionHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.WhiteWalkieEntity;

public class WhiteWalkieModel<T extends LivingEntity>
extends EntityModel<T> {
    private final ModelRenderer body;
    private final ModelRenderer ass;
    private final ModelRenderer tail;
    private final ModelRenderer frontLeftLeg;
    private final ModelRenderer frontLeftFoot;
    private final ModelRenderer frontRightLeg;
    private final ModelRenderer frontRightFoot;
    private final ModelRenderer backRightLeg;
    private final ModelRenderer backRightFoot;
    private final ModelRenderer backLeftLeg;
    private final ModelRenderer backLeftFoot;
    private final ModelRenderer bodyFur;
    private final ModelRenderer head;
    private final ModelRenderer upperMouth;
    private final ModelRenderer lowerMouth;
    private final ModelRenderer chinFur;
    private final ModelRenderer leftEar;
    private final ModelRenderer rightEar;
    protected float entityTick;
    protected float biteAnimationProgress;
    private boolean isSleeping;

    public WhiteWalkieModel() {
        this.field_78090_t = 256;
        this.field_78089_u = 256;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 3.4271f, 9.751f);
        this.body.func_78784_a(6, 109).func_228303_a_(-11.0f, -8.3771f, -27.5417f, 22.0f, 16.0f, 5.0f, 0.0f, false);
        this.body.func_78784_a(0, 0).func_228303_a_(-13.0f, -9.0385f, -24.5417f, 26.0f, 20.0f, 34.0f, 0.0f, false);
        this.body.func_78784_a(0, 54).func_228303_a_(-11.0f, -11.0385f, -22.5417f, 22.0f, 20.0f, 30.0f, 0.0f, false);
        this.ass = new ModelRenderer((Model)this);
        this.ass.func_78793_a(3.0f, 2.5729f, 23.874f);
        this.body.func_78792_a(this.ass);
        this.setRotationAngle(this.ass, -0.0436f, 0.0f, 0.0f);
        this.ass.func_78784_a(89, 0).func_228303_a_(-15.0f, -10.1202f, -18.2696f, 24.0f, 18.0f, 8.0f, 0.0f, false);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(0.0f, -5.4285f, 12.8316f);
        this.body.func_78792_a(this.tail);
        this.setRotationAngle(this.tail, 0.1309f, 0.0f, 0.0f);
        this.tail.func_78784_a(126, 29).func_228303_a_(-4.0f, -0.2505f, 1.0033f, 8.0f, 10.0f, 0.0f, 0.0f, false);
        this.frontLeftLeg = new ModelRenderer((Model)this);
        this.frontLeftLeg.func_78793_a(7.0f, 10.5729f, -19.751f);
        this.body.func_78792_a(this.frontLeftLeg);
        this.setRotationAngle(this.frontLeftLeg, -0.1309f, 0.0f, 0.0f);
        this.frontLeftLeg.func_78784_a(113, 61).func_228303_a_(-3.0f, -1.5847f, -3.176f, 6.0f, 10.0f, 6.0f, 0.0f, true);
        this.frontLeftFoot = new ModelRenderer((Model)this);
        this.frontLeftFoot.func_78793_a(0.0f, 8.3032f, -1.0862f);
        this.frontLeftLeg.func_78792_a(this.frontLeftFoot);
        this.setRotationAngle(this.frontLeftFoot, 0.1309f, 0.0f, 0.0f);
        this.frontLeftFoot.func_78784_a(110, 78).func_228303_a_(-3.0f, -2.0f, -4.25f, 6.0f, 4.0f, 8.0f, -0.01f, true);
        this.frontRightLeg = new ModelRenderer((Model)this);
        this.frontRightLeg.func_78793_a(-7.0f, 10.5729f, -21.001f);
        this.body.func_78792_a(this.frontRightLeg);
        this.setRotationAngle(this.frontRightLeg, -0.1309f, 0.0f, 0.0f);
        this.frontRightLeg.func_78784_a(113, 61).func_228303_a_(-3.0f, -1.4799f, -1.7758f, 6.0f, 10.0f, 6.0f, 0.0f, false);
        this.frontRightFoot = new ModelRenderer((Model)this);
        this.frontRightFoot.func_78793_a(0.0f, 8.408f, -0.6861f);
        this.frontRightLeg.func_78792_a(this.frontRightFoot);
        this.setRotationAngle(this.frontRightFoot, 0.1309f, 0.0f, 0.0f);
        this.frontRightFoot.func_78784_a(110, 78).func_228303_a_(-3.0f, -2.0f, -3.25f, 6.0f, 4.0f, 8.0f, -0.01f, false);
        this.backRightLeg = new ModelRenderer((Model)this);
        this.backRightLeg.func_78793_a(-8.0f, 10.5729f, 4.3735f);
        this.body.func_78792_a(this.backRightLeg);
        this.setRotationAngle(this.backRightLeg, -0.1309f, 0.0f, 0.0f);
        this.backRightLeg.func_78784_a(139, 63).func_228303_a_(-3.0f, -0.058f, -2.7389f, 6.0f, 8.0f, 6.0f, 0.0f, false);
        this.backRightFoot = new ModelRenderer((Model)this);
        this.backRightFoot.func_78793_a(0.0f, 8.0212f, -0.7307f);
        this.backRightLeg.func_78792_a(this.backRightFoot);
        this.setRotationAngle(this.backRightFoot, 0.1309f, 0.0f, 0.0f);
        this.backRightFoot.func_78784_a(139, 78).func_228303_a_(-3.0f, -2.0f, -4.0f, 6.0f, 4.0f, 8.0f, -0.01f, false);
        this.backLeftLeg = new ModelRenderer((Model)this);
        this.backLeftLeg.func_78793_a(8.0f, 10.5729f, 4.6658f);
        this.body.func_78792_a(this.backLeftLeg);
        this.setRotationAngle(this.backLeftLeg, -0.1309f, 0.0f, 0.0f);
        this.backLeftLeg.func_78784_a(139, 63).func_228303_a_(-3.0f, -0.0792f, -3.0f, 6.0f, 8.0f, 6.0f, 0.0f, true);
        this.backLeftFoot = new ModelRenderer((Model)this);
        this.backLeftFoot.func_78793_a(0.0f, 8.0f, -0.9917f);
        this.backLeftLeg.func_78792_a(this.backLeftFoot);
        this.setRotationAngle(this.backLeftFoot, 0.1309f, 0.0f, 0.0f);
        this.backLeftFoot.func_78784_a(139, 78).func_228303_a_(-3.0f, -2.0f, -4.0f, 6.0f, 4.0f, 8.0f, -0.01f, true);
        this.bodyFur = new ModelRenderer((Model)this);
        this.bodyFur.func_78793_a(0.0f, 11.8229f, 3.874f);
        this.body.func_78792_a(this.bodyFur);
        this.bodyFur.func_78784_a(64, 120).func_228303_a_(-11.0f, -2.25f, -28.0f, 22.0f, 7.0f, 0.0f, 0.0f, false);
        this.bodyFur.func_78784_a(64, 77).func_228303_a_(12.0f, -2.25f, -27.0f, 0.0f, 7.0f, 32.0f, 0.0f, false);
        this.bodyFur.func_78784_a(64, 77).func_228303_a_(-12.0f, -2.25f, -27.0f, 0.0f, 7.0f, 32.0f, 0.0f, false);
        this.bodyFur.func_78784_a(64, 119).func_228303_a_(-11.0f, -3.25f, 6.0f, 22.0f, 8.0f, 0.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 4.5813f, -4.4598f);
        this.setRotationAngle(this.head, 0.0436f, 0.0f, 0.0f);
        this.head.func_78784_a(4, 133).func_228303_a_(-10.0f, -9.879f, -20.199f, 20.0f, 18.0f, 10.0f, 0.0f, false);
        this.upperMouth = new ModelRenderer((Model)this);
        this.upperMouth.func_78793_a(0.0f, 4.7688f, -14.9009f);
        this.head.func_78792_a(this.upperMouth);
        this.upperMouth.func_78784_a(6, 162).func_228303_a_(-9.0f, -11.6868f, -16.3353f, 18.0f, 10.0f, 16.0f, 0.0f, false);
        this.upperMouth.func_78784_a(4, 170).func_228303_a_(3.0f, -2.3763f, -15.8167f, 4.0f, 2.0f, 1.0f, 0.0f, false);
        this.upperMouth.func_78784_a(4, 170).func_228303_a_(-7.0f, -2.3763f, -15.8167f, 4.0f, 2.0f, 1.0f, 0.0f, false);
        this.lowerMouth = new ModelRenderer((Model)this);
        this.lowerMouth.func_78793_a(0.0f, 2.912f, -18.2061f);
        this.head.func_78792_a(this.lowerMouth);
        this.lowerMouth.func_78784_a(3, 190).func_228303_a_(-8.0f, 0.2077f, -11.7395f, 16.0f, 4.0f, 12.0f, 0.0f, false);
        this.chinFur = new ModelRenderer((Model)this);
        this.chinFur.func_78793_a(0.0f, 4.5067f, 3.7492f);
        this.lowerMouth.func_78792_a(this.chinFur);
        this.chinFur.func_78784_a(3, 203).func_228303_a_(7.0f, -2.4798f, -14.4479f, 0.0f, 4.0f, 10.375f, 0.0f, false);
        this.chinFur.func_78784_a(3, 203).func_228303_a_(-7.0f, -2.4798f, -14.4479f, 0.0f, 4.0f, 10.375f, 0.0f, false);
        this.chinFur.func_78784_a(3, 208).func_228303_a_(-7.0f, -2.4798f, -14.4479f, 14.0f, 4.0f, 0.0f, 0.0f, false);
        this.leftEar = new ModelRenderer((Model)this);
        this.leftEar.func_78793_a(9.3123f, -8.7506f, -15.4048f);
        this.head.func_78792_a(this.leftEar);
        this.setRotationAngle(this.leftEar, 0.0f, 0.0f, 0.48f);
        this.leftEar.func_78784_a(1, 164).func_228303_a_(-0.7642f, -0.5365f, -1.5f, 6.0f, 1.0f, 3.0f, 0.0f, true);
        this.rightEar = new ModelRenderer((Model)this);
        this.rightEar.func_78793_a(-9.4837f, -8.6947f, -15.4048f);
        this.head.func_78792_a(this.rightEar);
        this.setRotationAngle(this.rightEar, 0.0f, 0.0f, -0.48f);
        this.rightEar.func_78784_a(1, 164).func_228303_a_(-5.2358f, -0.5365f, -1.5f, 6.0f, 1.0f, 3.0f, 0.0f, false);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        if (entity instanceof WhiteWalkieEntity) {
            this.biteAnimationProgress = ((WhiteWalkieEntity)entity).getBiteAnimationProgress(partialTicks);
        }
        this.entityTick = ((LivingEntity)entity).field_70173_aa;
        this.isSleeping = entity.func_70608_bn();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78808_h = 0.0f;
        this.leftEar.field_78808_h = (float)Math.toRadians(60.0);
        this.rightEar.field_78808_h = (float)Math.toRadians(-60.0);
        float speed = 0.95f;
        float spread = 0.6f;
        if (entity.func_70051_ag()) {
            speed = 0.125f;
        }
        this.frontRightLeg.field_78795_f = (float)(Math.toRadians(-8.0) + (double)(MathHelper.func_76134_b((float)(limbSwing * speed)) * spread * limbSwingAmount));
        this.frontLeftLeg.field_78795_f = (float)(Math.toRadians(-8.0) + (double)(MathHelper.func_76134_b((float)(limbSwing * speed + (float)Math.PI)) * spread * limbSwingAmount));
        this.backRightLeg.field_78795_f = (float)(Math.toRadians(-8.0) + (double)(MathHelper.func_76134_b((float)(limbSwing * speed + (float)Math.PI)) * spread * limbSwingAmount));
        this.backLeftLeg.field_78795_f = (float)(Math.toRadians(-8.0) + (double)(MathHelper.func_76134_b((float)(limbSwing * speed)) * spread * limbSwingAmount));
        if (entity instanceof WhiteWalkieEntity && ((WhiteWalkieEntity)entity).getShakeAnimationTime() > 0.0f) {
            this.head.field_78808_h = (float)(Math.cos((double)(ageInTicks * 0.4f) + Math.PI) * (double)0.1f);
            this.leftEar.field_78808_h = (float)((double)this.leftEar.field_78808_h + Math.cos((double)(ageInTicks * 0.8f) + Math.PI) * (double)0.2f);
            this.rightEar.field_78808_h = (float)((double)this.rightEar.field_78808_h + Math.cos((double)(ageInTicks * 0.8f) + Math.PI) * (double)0.2f);
        }
        if (this.biteAnimationProgress < 1.0f) {
            float angle = MathHelper.func_76126_a((float)(this.biteAnimationProgress * 0.5f * (float)Math.PI)) * 0.7f;
            this.upperMouth.field_78795_f = (float)Math.toRadians(-40.0) + angle;
            this.lowerMouth.field_78795_f = (float)Math.toRadians(40.0) - angle;
        } else if (this.biteAnimationProgress >= 1.0f) {
            ((LivingEntity)entity).field_82175_bq = false;
            this.upperMouth.field_78795_f = (float)Math.toRadians(0.0);
            this.lowerMouth.field_78795_f = (float)Math.toRadians(0.0);
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.field_217114_e) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            matrixStack.func_227861_a_(0.0, 1.5, 0.0);
        }
        matrixStack.func_227860_a_();
        if (this.isSleeping) {
            float progress = this.entityTick % 100.0f / 100.0f;
            progress = progress < 0.5f ? progress : 1.0f - progress;
            progress = EasingFunctionHelper.easeInOutCubic(Float.valueOf(progress));
            float initialScale = 1.0f;
            float scale = 1.0f + 1.0f * progress * 0.1f;
            matrixStack.func_227862_a_(scale, scale, scale);
        }
        this.body.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        matrixStack.func_227865_b_();
        this.head.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setSleepPosition(boolean flag) {
        this.showLegs(!flag);
        this.head.field_78797_d = flag ? 7.0f : 4.5813f;
    }

    public void showLegs(boolean showFlag) {
        if (showFlag) {
            this.frontRightLeg.field_78806_j = true;
            this.frontLeftLeg.field_78806_j = true;
            this.backRightLeg.field_78806_j = true;
            this.backLeftLeg.field_78806_j = true;
        } else {
            this.frontRightLeg.field_78806_j = false;
            this.frontLeftLeg.field_78806_j = false;
            this.backRightLeg.field_78806_j = false;
            this.backLeftLeg.field_78806_j = false;
        }
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

