/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items.armors;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.models.armors.CaptainCapeModel;

public class CaptainCapeItem
extends DyeableArmorItem {
    private String texture;
    private boolean hasOverlay;
    private static final HashMap<Integer, Crew> CREW_CACHING = new HashMap();

    public CaptainCapeItem(String texture, boolean hasOverlay) {
        super((IArmorMaterial)ModArmors.CAPTAIN_CAPE_MATERIAL, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(ModCreativeTabs.EQUIPMENT));
        this.texture = texture;
        this.hasOverlay = hasOverlay;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        CaptainCapeModel<LivingEntity> armorModel = new CaptainCapeModel<LivingEntity>();
        armorModel.func_225597_a_(entityLiving, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        return (A)((Object)armorModel);
    }

    @Nullable
    public String getArmorTexture(ItemStack itemStack, Entity entity, EquipmentSlotType slot, String type) {
        return String.format("%s:textures/models/armor/%s%s.png", "mineminenomi", this.texture, type == null || !this.hasOverlay ? "" : String.format("_%s", type));
    }

    public static void setCapeCrew(ItemStack stack, @Nullable Crew crew) {
        if (crew == null) {
            return;
        }
        stack.func_196082_o().func_218657_a("crew", (INBT)crew.write());
    }

    public static Crew getCapeCrew(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o().func_74775_l("crew");
        if (CREW_CACHING.containsKey(tag.hashCode())) {
            return CREW_CACHING.get(tag.hashCode());
        }
        Crew crew = Crew.from(tag);
        CREW_CACHING.put(tag.hashCode(), crew);
        return crew;
    }
}

