/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.WantedPosterData;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.WantedPosterTileEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenWantedPosterScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class WantedPosterItem
extends WallOrFloorItem {
    public static final String CANVAS_SIZE_NBT = "canvasSize";

    public WantedPosterItem(Block block) {
        super(block, (Block)ModBlocks.WANTED_POSTER.get(), new Item.Properties().func_200916_a(ModCreativeTabs.MISC).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && itemstack.func_77942_o()) {
            WantedPosterData wantedPosterData = WantedPosterData.from(itemstack.func_77978_p().func_74775_l("WPData"));
            wantedPosterData.checkIfExpired();
            WyNetwork.sendTo(new SOpenWantedPosterScreenPacket(wantedPosterData), player);
        }
        return ActionResult.func_226248_a_((Object)itemstack);
    }

    protected BlockState func_195945_b(BlockItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        ItemStack itemstack = ctx.func_195996_i();
        if (!player.field_70170_p.field_72995_K) {
            // empty if block
        }
        return super.func_195945_b(ctx);
    }

    protected boolean func_195943_a(BlockPos pos, World world, @Nullable PlayerEntity player, ItemStack itemStack, BlockState state) {
        WantedPosterTileEntity tileEntity;
        if (player != null && (tileEntity = (WantedPosterTileEntity)world.func_175625_s(pos)) != null && itemStack.func_77942_o()) {
            WantedPosterData wantedPosterData = WantedPosterData.from(itemStack.func_77978_p().func_74775_l("WPData"));
            wantedPosterData.checkIfExpired();
            tileEntity.setWantedPosterData(wantedPosterData);
            tileEntity.func_70296_d();
        }
        boolean flag = super.func_195943_a(pos, world, player, itemStack, state);
        return flag;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        WantedPosterData wantedPosterData;
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("WPData") && (wantedPosterData = WantedPosterData.from(itemStack.func_77978_p().func_74775_l("WPData"))).getTrackedPosition().isPresent()) {
            Vector3d pos = wantedPosterData.getTrackedPosition().get();
            list.add(StringTextComponent.field_240750_d_);
            list.add((ITextComponent)new StringTextComponent("x: " + (int)pos.field_72450_a + " y: " + (int)pos.field_72448_b + " z: " + (int)pos.field_72449_c));
        }
    }

    public static void setCanvasSize(ItemStack stack, CanvasSize size) {
        stack.func_196082_o().func_74768_a(CANVAS_SIZE_NBT, size.ordinal());
        stack.func_200302_a((ITextComponent)new StringTextComponent(WyHelper.capitalize(size.func_176610_l()) + " " + stack.func_77973_b().func_200295_i(stack).getString()));
    }

    public static boolean upgradeCanvasSize(ItemStack stack) {
        CanvasSize currentSize = WantedPosterItem.getCanvasSize(stack);
        if (currentSize.isMaximumSize()) {
            return false;
        }
        CanvasSize upgradeSize = CanvasSize.values()[currentSize.ordinal() + 1];
        WantedPosterItem.setCanvasSize(stack, upgradeSize);
        return true;
    }

    public static CanvasSize getCanvasSize(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return CanvasSize.SMALL;
        }
        CanvasSize size = CanvasSize.values()[stack.func_196082_o().func_74762_e(CANVAS_SIZE_NBT)];
        return size;
    }
}

