/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.FlagTileEntity;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FlagItem
extends BlockItem {
    public static final String CANVAS_SIZE_NBT = "canvasSize";

    public FlagItem(Block block) {
        super(block, new Item.Properties().func_200917_a(1).func_200916_a(ModCreativeTabs.MISC));
    }

    protected BlockState func_195945_b(BlockItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        ItemStack itemStack = ctx.func_195996_i();
        if (!player.field_70170_p.field_72995_K) {
            itemStack.func_196082_o().func_186854_a("uuid", player.func_110124_au());
            ExtendedWorldData worldData = ExtendedWorldData.get();
            Crew crew = worldData.getCrewWithMember(player.func_110124_au());
            if (crew != null) {
                itemStack.func_196082_o().func_218657_a("crew", (INBT)crew.write());
            }
        }
        return super.func_195945_b(ctx);
    }

    protected boolean func_195943_a(BlockPos pos, World world, @Nullable PlayerEntity player, ItemStack itemStack, BlockState state) {
        FlagTileEntity tileEntity;
        if (player != null && (tileEntity = (FlagTileEntity)world.func_175625_s(pos)) != null && itemStack.func_77942_o()) {
            Crew crew = Crew.from(itemStack.func_77978_p().func_74775_l("crew"));
            if (crew != null) {
                tileEntity.setCrew(crew);
            }
            tileEntity.func_70296_d();
            return true;
        }
        boolean flag = super.func_195943_a(pos, world, player, itemStack, state);
        return flag;
    }

    public static void setCanvasSize(ItemStack stack, CanvasSize size) {
        stack.func_196082_o().func_74768_a(CANVAS_SIZE_NBT, size.ordinal());
        stack.func_200302_a((ITextComponent)new StringTextComponent(WyHelper.capitalize(size.func_176610_l()) + " " + stack.func_77973_b().func_200295_i(stack).getString()));
    }

    public static boolean upgradeCanvasSize(ItemStack stack) {
        CanvasSize currentSize = FlagItem.getCanvasSize(stack);
        if (currentSize.isMaximumSize()) {
            return false;
        }
        CanvasSize upgradeSize = CanvasSize.values()[currentSize.ordinal() + 1];
        FlagItem.setCanvasSize(stack, upgradeSize);
        return true;
    }

    public static CanvasSize getCanvasSize(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return CanvasSize.SMALL;
        }
        CanvasSize size = CanvasSize.values()[stack.func_196082_o().func_74762_e(CANVAS_SIZE_NBT)];
        return size;
    }
}

