/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.interactions;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.interactions.Interaction;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModI18nInteractions;
import xyz.pixelatedw.mineminenomi.init.ModInteractions;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.interactions.BarkeeperRumorInteraction;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class BarkeeperBuyRumInteraction
extends Interaction {
    private static final int PRICE = 100;

    public BarkeeperBuyRumInteraction() {
    }

    public BarkeeperBuyRumInteraction(ITextComponent title) {
        super(title);
    }

    public static BarkeeperBuyRumInteraction buyRum() {
        TranslationTextComponent title = new TranslationTextComponent(ModI18nInteractions.BUY_RUM_TITLE, new Object[]{100});
        BarkeeperBuyRumInteraction interaction = new BarkeeperBuyRumInteraction((ITextComponent)title);
        interaction.setTriggerAction(interaction::buyRum);
        return interaction;
    }

    public static BarkeeperRumorInteraction close() {
        BarkeeperRumorInteraction interaction = new BarkeeperRumorInteraction((ITextComponent)ModI18nInteractions.CONTINUE_TITLE);
        interaction.setTriggerAction(interaction::closeMenu);
        return interaction;
    }

    public static BarkeeperBuyRumInteraction noBelly() {
        BarkeeperBuyRumInteraction interaction = new BarkeeperBuyRumInteraction();
        interaction.setMessage((ITextComponent)ModI18nInteractions.BARKEEPER_NO_BELLY_MESSAGE);
        interaction.setInteractions(ModInteractions.BARKEEPER_BUY_RUM_CONTINUE);
        return interaction;
    }

    public Interaction.InteractionResult closeMenu(PlayerEntity player, LivingEntity entity) {
        return Interaction.InteractionResult.close();
    }

    public Interaction.InteractionResult buyRum(PlayerEntity player, LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.getBelly() < 100L) {
            return Interaction.InteractionResult.next((Interaction)ModInteractions.BARKEEPER_RUMOR_NO_BELLY.get());
        }
        props.alterBelly(-100L, StatChangeSource.STORE);
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
        player.func_191521_c(((Item)ModItems.BOTTLE_OF_RUM.get()).func_190903_i());
        return Interaction.InteractionResult.close();
    }
}

