/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.client.CRequestSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.client.CRequestSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CToggleCombatModePacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CUseAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.components.CChangeAbilityAltModePacket;
import xyz.pixelatedw.mineminenomi.packets.client.entity.CSwitchVehicleModePacket;
import xyz.pixelatedw.mineminenomi.packets.client.entity.CSyncPlayerInputPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.COpenChallengesScreenPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.COpenCrewScreenPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.COpenPlayerScreenPacket;
import xyz.pixelatedw.mineminenomi.screens.ChallengesScreen;
import xyz.pixelatedw.mineminenomi.screens.CrewDetailsScreen;
import xyz.pixelatedw.mineminenomi.screens.PlayerStatsScreen;
import xyz.pixelatedw.mineminenomi.screens.QuestsTrackerScreen;
import xyz.pixelatedw.mineminenomi.screens.SelectHotbarAbilitiesScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
public class ModKeybindings {
    public static KeyBinding test;
    public static KeyBinding guiPlayer;
    public static KeyBinding enterCombatMode;
    public static KeyBinding nextCombatBar;
    public static KeyBinding prevCombatBar;
    public static KeyBinding lastCombatBar;
    public static KeyBinding changeAbilityMode;
    public static KeyBinding vehicleAltMode;
    public static KeyBinding openAbilities;
    public static KeyBinding openChallenges;
    public static KeyBinding openQuests;
    public static KeyBinding openCrew;
    public static ArrayList<KeyBinding> keyBindsCombatbar;
    public static KeyBinding[] combatbarShortcuts;
    private static final int[] PREVIOUS_INVENTORY_KEYBINDS;
    public static int serverMaxBars;

    public static void init() {
        if (WyDebug.isDebug()) {
            test = new KeyBinding("Test Key", 80, ModI18n.CATEGORY_GENERAL);
            ClientRegistry.registerKeyBinding((KeyBinding)test);
        }
        openAbilities = new KeyBinding(ModI18n.KEY_OPEN_ABILITIES, -1, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)openAbilities);
        openChallenges = new KeyBinding(ModI18n.KEY_OPEN_CHALLENGES, -1, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)openChallenges);
        openQuests = new KeyBinding(ModI18n.KEY_OPEN_QUESTS, -1, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)openQuests);
        openCrew = new KeyBinding(ModI18n.KEY_OPEN_CREW, -1, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)openCrew);
        vehicleAltMode = new KeyBinding(ModI18n.KEY_VEHICLE_ALT_MODE, 341, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)vehicleAltMode);
        guiPlayer = new KeyBinding(ModI18n.KEY_PLAYER, 82, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)guiPlayer);
        enterCombatMode = new KeyBinding(ModI18n.KEY_COMBATMODE, 342, ModI18n.CATEGORY_COMBATBAR);
        ClientRegistry.registerKeyBinding((KeyBinding)enterCombatMode);
        nextCombatBar = new KeyBinding(ModI18n.KEY_NEXT_COMBAT_BAR, 93, ModI18n.CATEGORY_COMBATBAR);
        ClientRegistry.registerKeyBinding((KeyBinding)nextCombatBar);
        prevCombatBar = new KeyBinding(ModI18n.KEY_PREV_COMBAT_BAR, 91, ModI18n.CATEGORY_COMBATBAR);
        ClientRegistry.registerKeyBinding((KeyBinding)prevCombatBar);
        lastCombatBar = new KeyBinding(ModI18n.KEY_LAST_COMBAT_BAR, -1, ModI18n.CATEGORY_COMBATBAR);
        ClientRegistry.registerKeyBinding((KeyBinding)lastCombatBar);
        changeAbilityMode = new KeyBinding(ModI18n.KEY_CHANGE_ABILITY_MODE, 340, ModI18n.CATEGORY_COMBATBAR);
        ClientRegistry.registerKeyBinding((KeyBinding)changeAbilityMode);
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT1, 49, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT2, 50, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT3, 51, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT4, 52, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT5, 53, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT6, 54, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT7, 55, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT8, 56, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT1, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT2, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT3, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT4, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT5, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT6, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT7, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT8, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT1, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT2, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT3, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT4, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT5, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT6, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT7, -1, ModI18n.CATEGORY_COMBATBAR));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT8, -1, ModI18n.CATEGORY_COMBATBAR));
        for (KeyBinding key : keyBindsCombatbar) {
            ClientRegistry.registerKeyBinding((KeyBinding)key);
        }
        ModKeybindings.combatbarShortcuts[0] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT1, -1, ModI18n.CATEGORY_COMBATBAR);
        ModKeybindings.combatbarShortcuts[1] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT2, -1, ModI18n.CATEGORY_COMBATBAR);
        ModKeybindings.combatbarShortcuts[2] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT3, -1, ModI18n.CATEGORY_COMBATBAR);
        ModKeybindings.combatbarShortcuts[3] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT4, -1, ModI18n.CATEGORY_COMBATBAR);
        ModKeybindings.combatbarShortcuts[4] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT5, -1, ModI18n.CATEGORY_COMBATBAR);
        ModKeybindings.combatbarShortcuts[5] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT6, -1, ModI18n.CATEGORY_COMBATBAR);
        ModKeybindings.combatbarShortcuts[6] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT7, -1, ModI18n.CATEGORY_COMBATBAR);
        ModKeybindings.combatbarShortcuts[7] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT8, -1, ModI18n.CATEGORY_COMBATBAR);
        ModKeybindings.combatbarShortcuts[8] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT9, -1, ModI18n.CATEGORY_COMBATBAR);
        ModKeybindings.combatbarShortcuts[9] = new KeyBinding(ModI18n.KEY_BAR_SHORTCUT10, -1, ModI18n.CATEGORY_COMBATBAR);
        for (KeyBinding key : combatbarShortcuts) {
            ClientRegistry.registerKeyBinding((KeyBinding)key);
        }
    }

    public static boolean isShiftKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
    }

    public static boolean isAltKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)342) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)346);
    }

    public static boolean isSpaceKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)32);
    }

    @SubscribeEvent
    public static void onPlayerJoins(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            for (int i = 0; i < PREVIOUS_INVENTORY_KEYBINDS.length; ++i) {
                ModKeybindings.PREVIOUS_INVENTORY_KEYBINDS[i] = -1;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaves(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        for (int i = 0; i < mc.field_71474_y.field_151456_ac.length; ++i) {
            KeyBinding kb = mc.field_71474_y.field_151456_ac[i];
            if (PREVIOUS_INVENTORY_KEYBINDS[i] == -1) continue;
            kb.func_197979_b(InputMappings.func_197954_a((int)PREVIOUS_INVENTORY_KEYBINDS[i], (int)0));
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseInputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null || event.getAction() == 0) {
            return;
        }
        InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(event.getButton());
        ModKeybindings.checkKeybindings((PlayerEntity)player, input, event.getAction(), event.getButton(), 0);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null || event.getAction() == 0) {
            return;
        }
        InputMappings.Input input = InputMappings.func_197954_a((int)event.getKey(), (int)event.getScanCode());
        ModKeybindings.checkKeybindings((PlayerEntity)player, input, event.getAction(), event.getKey(), 1);
    }

    private static void checkKeybindings(PlayerEntity player, InputMappings.Input input, int action, int key, int type) {
        boolean isSecondaryScreenOpen;
        Screen screen;
        Minecraft mc = Minecraft.func_71410_x();
        if (vehicleAltMode.isActiveAndMatches(input)) {
            WyNetwork.sendToServer(new CSwitchVehicleModePacket());
        }
        boolean isPlayerScreen = (screen = mc.field_71462_r) != null && screen instanceof PlayerStatsScreen;
        boolean isAbilitiesScreen = screen != null && screen instanceof SelectHotbarAbilitiesScreen;
        boolean isCrewScreen = screen != null && screen instanceof CrewDetailsScreen;
        boolean isChallengesScreen = screen != null && screen instanceof ChallengesScreen;
        boolean isQuestScreen = screen != null && screen instanceof QuestsTrackerScreen;
        boolean bl = isSecondaryScreenOpen = isAbilitiesScreen || isCrewScreen || isChallengesScreen || isQuestScreen;
        if (action == 1) {
            ModKeybindings.checkScreenActivation(mc, openAbilities, input, action, key, type, screen, isAbilitiesScreen, () -> new CRequestSyncAbilityDataPacket(true));
            ModKeybindings.checkScreenActivation(mc, openChallenges, input, action, key, type, screen, isChallengesScreen, () -> new COpenChallengesScreenPacket());
            ModKeybindings.checkScreenActivation(mc, openQuests, input, action, key, type, screen, isQuestScreen, () -> new CRequestSyncQuestDataPacket(true));
            ModKeybindings.checkScreenActivation(mc, openCrew, input, action, key, type, screen, isCrewScreen, () -> new COpenCrewScreenPacket());
            if (guiPlayer.isActiveAndMatches(input) && guiPlayer.func_151468_f() || (screen == null || isPlayerScreen || isSecondaryScreenOpen) && type == 1 && key == guiPlayer.getKey().func_197937_c()) {
                if (isPlayerScreen) {
                    mc.func_147108_a(null);
                } else if (isSecondaryScreenOpen) {
                    WyNetwork.sendToServer(new COpenPlayerScreenPacket());
                } else if (screen == null) {
                    WyNetwork.sendToServer(new COpenPlayerScreenPacket());
                }
            }
        }
        if (screen != null) {
            return;
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
        if (entityStatsProps.isInCombatMode() && action != 2) {
            int bars = ClientConfig.INSTANCE.getAbilityBarsOnScreen();
            int clientMaxBars = CommonConfig.INSTANCE.getAbilityBars();
            int maxBars = Math.min(clientMaxBars, serverMaxBars);
            int amount = Math.min(bars, maxBars);
            if (nextCombatBar.isActiveAndMatches(input) && nextCombatBar.func_151468_f()) {
                if (abilityDataProps.getCombatBarSet() + amount < maxBars) {
                    abilityDataProps.nextCombatBarSet(amount);
                } else {
                    abilityDataProps.setCombatBarSet(0);
                }
            } else if (prevCombatBar.isActiveAndMatches(input) && prevCombatBar.func_151468_f()) {
                if (abilityDataProps.getCombatBarSet() - amount >= 0) {
                    abilityDataProps.prevCombatBarSet(amount);
                } else if (maxBars == amount) {
                    abilityDataProps.setCombatBarSet(0);
                } else {
                    int barsOnLastPage = 0;
                    for (int i = maxBars; i > 0; i -= amount) {
                        barsOnLastPage = i;
                    }
                    abilityDataProps.setCombatBarSet(maxBars - barsOnLastPage);
                }
            } else if (lastCombatBar.isActiveAndMatches(input) && lastCombatBar.func_151468_f()) {
                int lastCombatBarSet = abilityDataProps.getLastCombatBarSet();
                abilityDataProps.setCombatBarSet(lastCombatBarSet);
            }
            int i = 0;
            for (KeyBinding keybind : combatbarShortcuts) {
                if (keybind.isActiveAndMatches(input) && keybind.func_151468_f()) {
                    int bar = i * bars + 1;
                    bar = MathHelper.func_76125_a((int)bar, (int)1, (int)(clientMaxBars - 1));
                    amount = Math.min(bar, maxBars);
                    abilityDataProps.setCombatBarSet(amount - 1);
                }
                ++i;
            }
        }
        if (!WyDebug.isDebug() || test.func_151470_d()) {
            // empty if block
        }
        if (enterCombatMode.isActiveAndMatches(input) && enterCombatMode.func_151468_f()) {
            ModKeybindings.keybindsAssignment(entityStatsProps);
        }
        for (int i = 0; i < keyBindsCombatbar.size(); ++i) {
            int bar = i / 8;
            if (!keyBindsCombatbar.get(i).isActiveAndMatches(input) || !keyBindsCombatbar.get(i).func_151468_f() || action == 2) continue;
            int k = i % 8 + (abilityDataProps.getCombatBarSet() + bar) * 8;
            Object abl = abilityDataProps.getEquippedAbility(k);
            boolean isOnCooldown = false;
            if (abl != null && abl.hasComponent(ModAbilityKeys.COOLDOWN)) {
                isOnCooldown = abl.getComponent(ModAbilityKeys.COOLDOWN).map(comp -> comp.isOnCooldown() && comp.getCooldown() > 10.0f).get();
            }
            if (entityStatsProps.isInCombatMode() && abl != null) {
                if (isOnCooldown) continue;
                if (changeAbilityMode.func_151470_d() && abl.hasComponent(ModAbilityKeys.ALT_MODE)) {
                    WyNetwork.sendToServer(new CChangeAbilityAltModePacket(k));
                    continue;
                }
                WyNetwork.sendToServer(new CUseAbilityPacket(k));
                continue;
            }
            player.field_71071_by.field_70461_c = i % 8;
        }
    }

    private static <P> void checkScreenActivation(Minecraft mc, KeyBinding keybind, InputMappings.Input input, int action, int key, int type, Screen currentScreen, boolean isNeededScreen, Supplier<P> packet) {
        if (keybind.isActiveAndMatches(input) && keybind.func_151468_f() || (currentScreen == null || isNeededScreen) && type == 1 && key == keybind.getKey().func_197937_c()) {
            if (isNeededScreen) {
                mc.func_147108_a(null);
            } else {
                WyNetwork.sendToServer(packet.get());
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
        if (entityStatsProps.getLeftImpulse() != player.field_70702_br || entityStatsProps.getForwardImpulse() != player.field_191988_bg || entityStatsProps.isJumping() != player.field_71158_b.field_78901_c) {
            entityStatsProps.setLeftImpulse(player.field_70702_br);
            entityStatsProps.setForwardImpulse(player.field_191988_bg);
            entityStatsProps.setJumping(player.field_71158_b.field_78901_c);
            WyNetwork.sendToServer(new CSyncPlayerInputPacket(mc.field_71439_g));
        }
    }

    private static void keybindsAssignment(IEntityStats entityStatsProps) {
        Minecraft mc = Minecraft.func_71410_x();
        entityStatsProps.setCombatMode(!entityStatsProps.isInCombatMode());
        if (entityStatsProps.isInCombatMode()) {
            for (int i = 0; i < mc.field_71474_y.field_151456_ac.length; ++i) {
                KeyBinding kb = mc.field_71474_y.field_151456_ac[i];
                ModKeybindings.PREVIOUS_INVENTORY_KEYBINDS[i] = kb.getKey().func_197937_c();
                kb.func_197979_b(InputMappings.field_197958_a);
            }
            KeyBinding.func_74508_b();
        } else {
            for (int i = 0; i < mc.field_71474_y.field_151456_ac.length; ++i) {
                KeyBinding kb = mc.field_71474_y.field_151456_ac[i];
                if (PREVIOUS_INVENTORY_KEYBINDS[i] == -1) {
                    kb.func_197979_b(InputMappings.func_197954_a((int)kb.func_197977_i().func_197937_c(), (int)0));
                    continue;
                }
                kb.func_197979_b(InputMappings.func_197954_a((int)PREVIOUS_INVENTORY_KEYBINDS[i], (int)0));
            }
            KeyBinding.func_74508_b();
        }
        WyNetwork.sendToServer(new CToggleCombatModePacket(entityStatsProps.isInCombatMode()));
    }

    public static boolean isHotbarKeyConflicting(KeyBinding keybind) {
        for (KeyBinding kb : keyBindsCombatbar) {
            if (kb.equals(keybind) || !kb.getKey().equals((Object)keybind.getKey()) || !kb.getKeyModifier().equals((Object)keybind.getKeyModifier())) continue;
            return true;
        }
        return false;
    }

    static {
        keyBindsCombatbar = new ArrayList();
        combatbarShortcuts = new KeyBinding[10];
        PREVIOUS_INVENTORY_KEYBINDS = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        serverMaxBars = 2;
    }
}

