/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import com.mojang.serialization.Codec;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.world.features.BoulderFeature;
import xyz.pixelatedw.mineminenomi.world.features.LargeIceSpikeFeature;
import xyz.pixelatedw.mineminenomi.world.features.LargeLakesFeature;
import xyz.pixelatedw.mineminenomi.world.features.NaturalDialFeature;
import xyz.pixelatedw.mineminenomi.world.features.PoneglyphFeature;
import xyz.pixelatedw.mineminenomi.world.features.RareTreeFeature;
import xyz.pixelatedw.mineminenomi.world.features.SnowFloorFeature;
import xyz.pixelatedw.mineminenomi.world.features.SnowMountainFeature;
import xyz.pixelatedw.mineminenomi.world.features.configs.SizedBlockStateFeatureConfig;
import xyz.pixelatedw.mineminenomi.world.features.ocean.OceanFloorModifierFeature;
import xyz.pixelatedw.mineminenomi.world.features.trees.SabaodyFoliagePlacer;
import xyz.pixelatedw.mineminenomi.world.features.trees.SabaodyTrunkPlacer;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class ModFeatures {
    public static final HashMap<Feature<?>, ConfiguredFeature<?, ?>> REGISTERED_FEATURES = new HashMap();
    public static final RegistryObject<Feature<NoFeatureConfig>> PONEGLYPH = WyRegistry.registerFeature("poneglyph", PoneglyphFeature::new);
    public static final RegistryObject<Feature<NoFeatureConfig>> OCEAN_FLOOR = WyRegistry.registerFeature("ocean_floor", OceanFloorModifierFeature::new);
    public static final RegistryObject<Feature<NoFeatureConfig>> SNOW_FLOOR = WyRegistry.registerFeature("snow_floor", SnowFloorFeature::new);
    public static final RegistryObject<Feature<NoFeatureConfig>> SKY_ISLANDS_NATURAL_DIAL = WyRegistry.registerFeature("sky_natural_dial", NaturalDialFeature::new);
    public static final RegistryObject<Feature<NoFeatureConfig>> BEACH_NATURAL_DIAL = WyRegistry.registerFeature("beach_natural_dial", NaturalDialFeature::new);
    public static final RegistryObject<Feature<ProbabilityConfig>> LARGE_ICE_SPIKE = WyRegistry.registerFeature("large_ice_spike", LargeIceSpikeFeature::new);
    public static final RegistryObject<Feature<ProbabilityConfig>> SNOW_MOUNTAIN = WyRegistry.registerFeature("snow_mountain", SnowMountainFeature::new);
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> RARE_TREE = WyRegistry.registerFeature("rare_tree", RareTreeFeature::new);
    public static final RegistryObject<Feature<SizedBlockStateFeatureConfig>> BOULDER = WyRegistry.registerFeature("boulder", BoulderFeature::new);
    public static final RegistryObject<Feature<BlockStateFeatureConfig>> LARGE_LAKE = WyRegistry.registerFeature("large_lake", LargeLakesFeature::new);
    public static final TrunkPlacerType<SabaodyTrunkPlacer> SABAODY_TRUNK_PLACER = ModFeatures.registerTrunkPlacer("sabaody_trunk_placer", SabaodyTrunkPlacer.CODEC);
    public static final RegistryObject<FoliagePlacerType<SabaodyFoliagePlacer>> SABAODY_FOLIAGE_PLACER = WyRegistry.registerFoliagePlacer("sabaody_foliage_placer", () -> new FoliagePlacerType(SabaodyFoliagePlacer.CODEC));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> SABAODY_MANGROVE = ModFeatures.getConfiguredTreeFeature("sabaody_tree");

    public static void setupFeatures(BiomeLoadingEvent event) {
        ConfiguredFeature poneglyph = ModFeatures.setupConfiguredFeature(((Feature)PONEGLYPH.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(1, 1, 100)).func_242728_a()).func_242731_b(1)));
        ConfiguredFeature skyNaturalDial = ModFeatures.setupConfiguredFeature(((Feature)SKY_ISLANDS_NATURAL_DIAL.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(150, 100, 256)).func_242728_a()).func_242731_b(50)));
        ConfiguredFeature beachNaturalDial = ModFeatures.setupConfiguredFeature(((Feature)SKY_ISLANDS_NATURAL_DIAL.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_((ConfiguredPlacement)Features.Placements.field_243996_g.func_242731_b(1)));
        event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, poneglyph);
        if (event.getCategory() == Biome.Category.BEACH || event.getCategory() == Biome.Category.OCEAN) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, skyNaturalDial);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, beachNaturalDial);
            ConfiguredFeature<?, ?> kairosekiOre = ModFeatures.registerOre((Block)ModBlocks.KAIROSEKI_ORE.get(), new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)ModBlocks.KAIROSEKI_ORE.get()).func_176223_P(), 6), Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(1, 1, 100)), CommonConfig.INSTANCE.getKairosekiSpawnCount());
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, kairosekiOre);
        }
    }

    private static ConfiguredFeature<BaseTreeFeatureConfig, ?> getConfiguredTreeFeature(String featureName) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243552_au, (ResourceLocation)new ResourceLocation("mineminenomi", featureName));
        return (ConfiguredFeature)WorldGenRegistries.field_243653_e.func_230516_a_(key);
    }

    private static <F extends Feature<?>, S extends ConfiguredFeature<?, ?>> S setupConfiguredFeature(S feature) {
        Feature structure = feature.field_222737_a;
        return (S)((ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)structure.getRegistryName(), feature));
    }

    private static ConfiguredFeature<?, ?> registerOre(Block ore, OreFeatureConfig oreFeatureConfig, ConfiguredPlacement configuredPlacement, int count) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ore.getRegistryName(), (Object)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)oreFeatureConfig).func_227228_a_(configuredPlacement).func_242728_a()).func_242731_b(count));
    }

    private static <P extends AbstractTrunkPlacer> TrunkPlacerType<P> registerTrunkPlacer(String key, Codec<P> codec) {
        key = "mineminenomi:" + key;
        TrunkPlacerType trunkPlacerType = null;
        try {
            trunkPlacerType = (TrunkPlacerType)ObfuscationReflectionHelper.findConstructor(TrunkPlacerType.class, (Class[])new Class[]{Codec.class}).newInstance(codec);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return (TrunkPlacerType)Registry.func_218325_a((Registry)Registry.field_239701_aw_, (String)key, trunkPlacerType);
    }

    private static <P extends FoliagePlacer> FoliagePlacerType<P> registerFoliagePlacer(String key, Codec<P> codec) {
        key = "mineminenomi:" + key;
        Object foliagePlacerType = null;
        return (FoliagePlacerType)Registry.func_218325_a((Registry)Registry.field_229389_v_, (String)key, foliagePlacerType);
    }

    public static void register(IEventBus eventBus) {
        WyRegistry.FEATURES.register(eventBus);
        WyRegistry.FOLIAGE_PLACER_TYPES.register(eventBus);
    }
}

