/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.config.WorldEventsConfig;
import xyz.pixelatedw.mineminenomi.entities.BombEntity;
import xyz.pixelatedw.mineminenomi.entities.BonChariEntity;
import xyz.pixelatedw.mineminenomi.entities.BottomHalfBodyEntity;
import xyz.pixelatedw.mineminenomi.entities.CannonEntity;
import xyz.pixelatedw.mineminenomi.entities.ChakramEntity;
import xyz.pixelatedw.mineminenomi.entities.DFItemEntity;
import xyz.pixelatedw.mineminenomi.entities.EntityCollectorEntity;
import xyz.pixelatedw.mineminenomi.entities.JangoEntity;
import xyz.pixelatedw.mineminenomi.entities.NetEntity;
import xyz.pixelatedw.mineminenomi.entities.PhysicalBodyEntity;
import xyz.pixelatedw.mineminenomi.entities.SpearEntity;
import xyz.pixelatedw.mineminenomi.entities.SphereEntity;
import xyz.pixelatedw.mineminenomi.entities.SpikeEntity;
import xyz.pixelatedw.mineminenomi.entities.StrikerEntity;
import xyz.pixelatedw.mineminenomi.entities.ThrowingWeaponEntity;
import xyz.pixelatedw.mineminenomi.entities.TornadoEntity;
import xyz.pixelatedw.mineminenomi.entities.UnicycleEntity;
import xyz.pixelatedw.mineminenomi.entities.VivreCardEntity;
import xyz.pixelatedw.mineminenomi.entities.WantedPosterPackageEntity;
import xyz.pixelatedw.mineminenomi.entities.dummies.CabajiDummyEntity;
import xyz.pixelatedw.mineminenomi.entities.dummies.DummyEntity;
import xyz.pixelatedw.mineminenomi.entities.dummies.FlyingFishDummyEntity;
import xyz.pixelatedw.mineminenomi.entities.dummies.JangoDummyEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.BarkeeperEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.BruteEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.CaptainEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.GruntEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.NotoriousEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.SkypieanCivilianEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.SkypieanTraderEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.SniperEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.BananawaniEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.BigDuckEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.BlagoriEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.BlugoriEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.BoxingDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.DenDenMushiEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.FightingFishEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.FlyingFishEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.HumandrillEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.KungFuDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.LapahnEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.LegendaryMasterDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.PandaSharkEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.SeaCowEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.WanderingDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.WhiteWalkieEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.WrestlingDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.YagaraBullEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.bandits.HigumaEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MarineTraderEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.MorganEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.PacifistaEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.AlvidaEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.PirateBomberEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.PirateTraderEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.arlongpirates.ArlongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.arlongpirates.ChewEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.arlongpirates.KuroobiEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks.MissMerryChristmasEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks.MissValentineEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks.Mr0Entity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks.Mr1Entity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks.Mr3Entity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks.Mr4Entity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks.Mr5Entity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.blackcatpirates.BuchiEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.blackcatpirates.KuroEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.blackcatpirates.ShamEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.buggypirates.BuggyEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.buggypirates.CabajiEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.DonKriegEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.GinEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.PearlEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.ArtOfWeatherTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.BlackLegTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.BrawlerTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.DoctorTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.SniperTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.SwordsmanTrainerEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.objectives.SniperTargetEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.worldgov.CelestialDragonEntity;
import xyz.pixelatedw.mineminenomi.init.ModBiomes;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final EntityClassification MARINES = EntityClassification.create((String)"marines", (String)"marines", (int)25, (boolean)false, (boolean)true, (int)128);
    public static final EntityClassification PIRATES = EntityClassification.create((String)"pirates", (String)"pirates", (int)25, (boolean)false, (boolean)true, (int)128);
    public static final EntityClassification BANDITS = EntityClassification.create((String)"bandits", (String)"bandits", (int)25, (boolean)false, (boolean)true, (int)128);
    public static final ArrayList<BiomeDictionary.Type> GENERIC_ONES = Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SWAMP});
    public static final ArrayList<BiomeDictionary.Type> PIRATE_BIOMES = Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST});
    public static final ArrayList<BiomeDictionary.Type> MARINE_BIOMES = Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SWAMP});
    public static final ArrayList<BiomeDictionary.Type> BANDIT_BIOMES = Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MESA});
    public static final RegistryObject<EntityType<GruntEntity>> MARINE_GRUNT = ModEntities.registerMarineWithSpawnEgg("Marine Grunt", () -> WyRegistry.createEntityType(GruntEntity::createMarineGrunt, MARINES).func_206830_a("mineminenomi:marine_grunt"));
    public static final RegistryObject<EntityType<BruteEntity>> MARINE_BRUTE = ModEntities.registerMarineWithSpawnEgg("Marine Brute", () -> WyRegistry.createEntityType(BruteEntity::createMarineBrute, MARINES).func_220321_a(0.8f, 2.3f).func_206830_a("mineminenomi:marine_brute"));
    public static final RegistryObject<EntityType<SniperEntity>> MARINE_SNIPER = ModEntities.registerMarineWithSpawnEgg("Marine Sniper", () -> WyRegistry.createEntityType(SniperEntity::createMarineSniper, MARINES).func_206830_a("mineminenomi:marine_sniper"));
    public static final RegistryObject<EntityType<CaptainEntity>> MARINE_CAPTAIN = ModEntities.registerMarineWithSpawnEgg("Marine Captain", () -> WyRegistry.createEntityType(CaptainEntity::createMarineCaptain, MARINES).func_206830_a("mineminenomi:marine_captain"));
    public static final RegistryObject<EntityType<MarineTraderEntity>> MARINE_TRADER = ModEntities.registerMarineWithSpawnEgg("Marine Trader", () -> WyRegistry.createEntityType(MarineTraderEntity::new, MARINES).func_206830_a("mineminenomi:marine_trader"));
    public static final RegistryObject<EntityType<PacifistaEntity>> PACIFISTA = ModEntities.registerMarineWithSpawnEgg("Pacifista", () -> WyRegistry.createEntityType(PacifistaEntity::new, MARINES).func_220321_a(1.5f, 3.5f).func_206830_a("mineminenomi:pacifista"));
    public static final RegistryObject<EntityType<NotoriousEntity>> MARINE_VICE_ADMIRAL = WyRegistry.registerEntityType("Marine Vice Admiral", () -> WyRegistry.createEntityType(NotoriousEntity::createMarine, MARINES).func_220321_a(0.6f, 2.0f).func_206830_a("mineminenomi:marine_vice_admiral"));
    public static final RegistryObject<EntityType<MorganEntity>> MORGAN = WyRegistry.registerEntityType("Morgan", () -> WyRegistry.createEntityType(MorganEntity::new, MARINES).func_220321_a(0.8f, 2.7f).func_206830_a("mineminenomi:morgan"));
    public static final RegistryObject<EntityType<CelestialDragonEntity>> CELESTIAL_DRAGON = ModEntities.registerWorldGovWithSpawnEgg("Celestial Dragon", () -> WyRegistry.createEntityType(CelestialDragonEntity::new).func_206830_a("mineminenomi:celestial_dragon"));
    public static final RegistryObject<EntityType<GruntEntity>> PIRATE_GRUNT = ModEntities.registerPirateWithSpawnEgg("Pirate Grunt", () -> WyRegistry.createEntityType(GruntEntity::createPirateGrunt, PIRATES).func_206830_a("mineminenomi:pirate_grunt"));
    public static final RegistryObject<EntityType<BruteEntity>> PIRATE_BRUTE = ModEntities.registerPirateWithSpawnEgg("Pirate Brute", () -> WyRegistry.createEntityType(BruteEntity::createPirateBrute, PIRATES).func_220321_a(0.8f, 2.3f).func_206830_a("mineminenomi:pirate_brute"));
    public static final RegistryObject<EntityType<CaptainEntity>> PIRATE_CAPTAIN = ModEntities.registerPirateWithSpawnEgg("Pirate Captain", () -> WyRegistry.createEntityType(CaptainEntity::createPirateCaptain, PIRATES).func_206830_a("mineminenomi:pirate_captain"));
    public static final RegistryObject<EntityType<PirateTraderEntity>> PIRATE_TRADER = ModEntities.registerPirateWithSpawnEgg("Pirate Trader", () -> WyRegistry.createEntityType(PirateTraderEntity::new, PIRATES).func_206830_a("mineminenomi:pirate_trader"));
    public static final RegistryObject<EntityType<PirateBomberEntity>> PIRATE_BOMBER = ModEntities.registerPirateWithSpawnEgg("Pirate Bomber", () -> WyRegistry.createEntityType(PirateBomberEntity::new, PIRATES).func_206830_a("mineminenomi:pirate_bomber"));
    public static final RegistryObject<EntityType<NotoriousEntity>> PIRATE_NOTORIOUS_CAPTAIN = WyRegistry.registerEntityType("Pirate Notorious Captain", () -> WyRegistry.createEntityType(NotoriousEntity::createPirate, MARINES).func_220321_a(0.6f, 2.0f).func_206830_a("mineminenomi:pirate_notorious_captain"));
    public static final RegistryObject<EntityType<BuggyEntity>> BUGGY = WyRegistry.registerEntityType("Buggy", () -> WyRegistry.createEntityType(BuggyEntity::new).func_206830_a("mineminenomi:buggy"));
    public static final RegistryObject<EntityType<AlvidaEntity>> ALVIDA = WyRegistry.registerEntityType("Alvida", () -> WyRegistry.createEntityType(AlvidaEntity::new).func_206830_a("mineminenomi:alvida"));
    public static final RegistryObject<EntityType<AlvidaEntity>> ALVIDA_SLIM = WyRegistry.registerEntityType("Alvida", "alvida2", () -> WyRegistry.createEntityType(AlvidaEntity::new).func_206830_a("mineminenomi:alvida2"));
    public static final RegistryObject<EntityType<CabajiEntity>> CABAJI = WyRegistry.registerEntityType("Cabaji", () -> WyRegistry.createEntityType(CabajiEntity::new).func_206830_a("mineminenomi:cabaji"));
    public static final RegistryObject<EntityType<ShamEntity>> SHAM = WyRegistry.registerEntityType("Sham", () -> WyRegistry.createEntityType(ShamEntity::new).func_206830_a("mineminenomi:sham"));
    public static final RegistryObject<EntityType<BuchiEntity>> BUCHI = WyRegistry.registerEntityType("Buchi", () -> WyRegistry.createEntityType(BuchiEntity::new).func_206830_a("mineminenomi:buchi"));
    public static final RegistryObject<EntityType<JangoEntity>> JANGO = WyRegistry.registerEntityType("Jango", () -> WyRegistry.createEntityType(JangoEntity::new).func_206830_a("mineminenomi:jango"));
    public static final RegistryObject<EntityType<KuroEntity>> KURO = WyRegistry.registerEntityType("Kuro", () -> WyRegistry.createEntityType(KuroEntity::new).func_206830_a("mineminenomi:kuro"));
    public static final RegistryObject<EntityType<GinEntity>> GIN = WyRegistry.registerEntityType("Gin", () -> WyRegistry.createEntityType(GinEntity::new).func_206830_a("mineminenomi:gin"));
    public static final RegistryObject<EntityType<PearlEntity>> PEARL = WyRegistry.registerEntityType("Pearl", () -> WyRegistry.createEntityType(PearlEntity::new).func_220321_a(0.8f, 2.5f).func_206830_a("mineminenomi:pearl"));
    public static final RegistryObject<EntityType<DonKriegEntity>> DON_KRIEG = WyRegistry.registerEntityType("Don Krieg", () -> WyRegistry.createEntityType(DonKriegEntity::new).func_220321_a(0.8f, 2.5f).func_206830_a("mineminenomi:don_krieg"));
    public static final RegistryObject<EntityType<ChewEntity>> CHEW = WyRegistry.registerEntityType("Chew", () -> WyRegistry.createEntityType(ChewEntity::new).func_220321_a(0.75f, 2.75f).func_206830_a("mineminenomi:chew"));
    public static final RegistryObject<EntityType<KuroobiEntity>> KUROOBI = WyRegistry.registerEntityType("Kuroobi", () -> WyRegistry.createEntityType(KuroobiEntity::new).func_220321_a(0.75f, 2.7f).func_206830_a("mineminenomi:kuroobi"));
    public static final RegistryObject<EntityType<ArlongEntity>> ARLONG = WyRegistry.registerEntityType("Arlong", () -> WyRegistry.createEntityType(ArlongEntity::new).func_220321_a(0.75f, 2.75f).func_206830_a("mineminenomi:arlong"));
    public static final RegistryObject<EntityType<Mr5Entity>> MR5 = WyRegistry.registerEntityType("Mr 5", () -> WyRegistry.createEntityType(Mr5Entity::new).func_206830_a("mineminenomi:mr5"));
    public static final RegistryObject<EntityType<MissValentineEntity>> MISS_VALENTINE = WyRegistry.registerEntityType("Miss Valentine", () -> WyRegistry.createEntityType(MissValentineEntity::new).func_206830_a("mineminenomi:miss_valentine"));
    public static final RegistryObject<EntityType<Mr4Entity>> MR4 = WyRegistry.registerEntityType("Mr 4", () -> WyRegistry.createEntityType(Mr4Entity::new).func_206830_a("mineminenomi:mr4"));
    public static final RegistryObject<EntityType<MissMerryChristmasEntity>> MISS_MERRY_CHRISTMAS = WyRegistry.registerEntityType("Miss Merry Christmas", () -> WyRegistry.createEntityType(MissMerryChristmasEntity::new).func_206830_a("mineminenomi:miss_merry_christmas"));
    public static final RegistryObject<EntityType<Mr3Entity>> MR3 = WyRegistry.registerEntityType("Mr 3", () -> WyRegistry.createEntityType(Mr3Entity::new).func_206830_a("mineminenomi:mr3"));
    public static final RegistryObject<EntityType<Mr1Entity>> MR1 = WyRegistry.registerEntityType("Mr 1", () -> WyRegistry.createEntityType(Mr1Entity::new).func_220321_a(0.9f, 2.3f).func_206830_a("mineminenomi:mr1"));
    public static final RegistryObject<EntityType<Mr0Entity>> MR0 = WyRegistry.registerEntityType("Mr 0", () -> WyRegistry.createEntityType(Mr0Entity::new).func_220321_a(0.7f, 2.0f).func_206830_a("mineminenomi:mr0"));
    public static final RegistryObject<EntityType<GruntEntity>> BANDIT_GRUNT = ModEntities.registerBanditWithSpawnEgg("Bandit Grunt", () -> WyRegistry.createEntityType(GruntEntity::createBanditGrunt, BANDITS).func_206830_a("mineminenomi:bandit_grunt"));
    public static final RegistryObject<EntityType<BruteEntity>> BANDIT_BRUTE = ModEntities.registerBanditWithSpawnEgg("Bandit Brute", () -> WyRegistry.createEntityType(BruteEntity::createBanditBrute, BANDITS).func_220321_a(0.8f, 2.3f).func_206830_a("mineminenomi:bandit_brute"));
    public static final RegistryObject<EntityType<SniperEntity>> BANDIT_SNIPER = ModEntities.registerBanditWithSpawnEgg("Bandit Sniper", () -> WyRegistry.createEntityType(SniperEntity::createBanditSniper, BANDITS).func_206830_a("mineminenomi:bandit_sniper"));
    public static final RegistryObject<EntityType<CaptainEntity>> BANDIT_CAPTAIN = ModEntities.registerBanditWithSpawnEgg("Bandit Leader", () -> WyRegistry.createEntityType(CaptainEntity::createBanditCaptain, BANDITS).func_206830_a("mineminenomi:bandit_captain"));
    public static final RegistryObject<EntityType<HigumaEntity>> HIGUMA = WyRegistry.registerEntityType("Higuma", () -> WyRegistry.createEntityType(HigumaEntity::new, BANDITS).func_220321_a(0.8f, 1.9f).func_206830_a("mineminenomi:higuma"));
    public static final RegistryObject<EntityType<SwordsmanTrainerEntity>> SWORDSMAN_TRAINER = ModEntities.registerFactionlessWithSpawnEgg("Swordsman Trainer", () -> WyRegistry.createEntityType(SwordsmanTrainerEntity::new).func_206830_a("mineminenomi:swordsman_trainer"));
    public static final RegistryObject<EntityType<SniperTrainerEntity>> SNIPER_TRAINER = ModEntities.registerFactionlessWithSpawnEgg("Sniper Trainer", () -> WyRegistry.createEntityType(SniperTrainerEntity::new).func_206830_a("mineminenomi:sniper_trainer"));
    public static final RegistryObject<EntityType<ArtOfWeatherTrainerEntity>> ART_OF_WEATHER_TRAINER = ModEntities.registerFactionlessWithSpawnEgg("Art of Weather Trainer", () -> WyRegistry.createEntityType(ArtOfWeatherTrainerEntity::new).func_206830_a("mineminenomi:art_of_weather_trainer"));
    public static final RegistryObject<EntityType<DoctorTrainerEntity>> DOCTOR_TRAINER = ModEntities.registerFactionlessWithSpawnEgg("Doctor Trainer", () -> WyRegistry.createEntityType(DoctorTrainerEntity::new).func_206830_a("mineminenomi:doctor_trainer"));
    public static final RegistryObject<EntityType<BrawlerTrainerEntity>> BRAWLER_TRAINER = ModEntities.registerFactionlessWithSpawnEgg("Brawler Trainer", () -> WyRegistry.createEntityType(BrawlerTrainerEntity::new).func_206830_a("mineminenomi:brawler_trainer"));
    public static final RegistryObject<EntityType<BlackLegTrainerEntity>> BLACK_LEG_TRAINER = ModEntities.registerFactionlessWithSpawnEgg("Black Leg Trainer", () -> WyRegistry.createEntityType(BlackLegTrainerEntity::new).func_206830_a("mineminenomi:black_leg_trainer"));
    public static final RegistryObject<EntityType<SkypieanCivilianEntity>> SKYPIEAN_CIVILIAN = ModEntities.registerFactionlessWithSpawnEgg("Skypiean Civilian", () -> WyRegistry.createEntityType(SkypieanCivilianEntity::new).func_206830_a("mineminenomi:skypiean_civilian"));
    public static final RegistryObject<EntityType<SkypieanTraderEntity>> SKYPIEAN_TRADER = ModEntities.registerFactionlessWithSpawnEgg("Skypiean Trader", () -> WyRegistry.createEntityType(SkypieanTraderEntity::new).func_206830_a("mineminenomi:skypiean_trader"));
    public static final RegistryObject<EntityType<BarkeeperEntity>> BARKEEPER = ModEntities.registerFactionlessWithSpawnEgg("Barkeeper", () -> WyRegistry.createEntityType(BarkeeperEntity::new).func_206830_a("mineminenomi:barkeeper"));
    public static final RegistryObject<EntityType<DenDenMushiEntity>> DEN_DEN_MUSHI = ModEntities.registerAnimalWithSpawnEgg("Den Den Mushi", () -> WyRegistry.createEntityType(DenDenMushiEntity::new, EntityClassification.CREATURE).func_220321_a(0.8f, 0.8f).func_206830_a("mineminenomi:den_den_mushi"));
    public static final RegistryObject<EntityType<LapahnEntity>> LAPAHN = ModEntities.registerAnimalWithSpawnEgg("Lapahn", () -> WyRegistry.createEntityType(LapahnEntity::new, EntityClassification.CREATURE).func_220321_a(1.5f, 2.3f).func_206830_a("mineminenomi:lapahn"));
    public static final RegistryObject<EntityType<YagaraBullEntity>> YAGARA_BULL = ModEntities.registerAnimalWithSpawnEgg("Yagara Bull", () -> WyRegistry.createEntityType(YagaraBullEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(1.4f, 1.6f).func_233606_a_(10).func_206830_a("mineminenomi:yagara_bull"));
    public static final RegistryObject<EntityType<HumandrillEntity>> HUMANDRILL = ModEntities.registerAnimalWithSpawnEgg("Humandrill", () -> WyRegistry.createEntityType(HumandrillEntity::new, EntityClassification.CREATURE).func_220321_a(1.0f, 2.5f).func_206830_a("mineminenomi:humandrill"));
    public static final RegistryObject<EntityType<FightingFishEntity>> FIGHTING_FISH = ModEntities.registerAnimalWithSpawnEgg("Fighting Fish", () -> WyRegistry.createEntityType(FightingFishEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(3.0f, 3.0f).func_206830_a("mineminenomi:fighting_fish"));
    public static final RegistryObject<EntityType<BananawaniEntity>> BANANAWANI = ModEntities.registerAnimalWithSpawnEgg("Bananawani", () -> WyRegistry.createEntityType(BananawaniEntity::new, EntityClassification.CREATURE).func_220321_a(2.0f, 1.75f).func_206830_a("mineminenomi:bananwani"));
    public static final RegistryObject<EntityType<BigDuckEntity>> BIG_DUCK = ModEntities.registerAnimalWithSpawnEgg("Super Spot-Billed Duck", () -> WyRegistry.createEntityType(BigDuckEntity::new, EntityClassification.CREATURE).func_220321_a(1.25f, 1.75f).func_206830_a("mineminenomi:big_duck"));
    public static final RegistryObject<EntityType<SeaCowEntity>> SEA_COW = ModEntities.registerAnimalWithSpawnEgg("Sea Cow", () -> WyRegistry.createEntityType(SeaCowEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:sea_cow"));
    public static final RegistryObject<EntityType<WhiteWalkieEntity>> WHITE_WALKIE = ModEntities.registerAnimalWithSpawnEgg("White Walkie", () -> WyRegistry.createEntityType(WhiteWalkieEntity::new, EntityClassification.CREATURE).func_220321_a(2.0f, 2.0f).func_206830_a("mineminenomi:white_walkie"));
    public static final RegistryObject<EntityType<PandaSharkEntity>> PANDA_SHARK = ModEntities.registerAnimalWithSpawnEgg("Panda Shark", () -> WyRegistry.createEntityType(PandaSharkEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:panda_shark"));
    public static final RegistryObject<EntityType<FlyingFishEntity>> FLYING_FISH = ModEntities.registerAnimalWithSpawnEgg("Flying Fish", () -> WyRegistry.createEntityType(FlyingFishEntity::new, EntityClassification.WATER_CREATURE).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:flying_fish"));
    public static final RegistryObject<EntityType<BlugoriEntity>> BLUGORI = ModEntities.registerAnimalWithSpawnEgg("Blugori", () -> WyRegistry.createEntityType(BlugoriEntity::new, EntityClassification.CREATURE).func_220321_a(1.0f, 1.5f).func_206830_a("mineminenomi:blugori"));
    public static final RegistryObject<EntityType<BlagoriEntity>> BLAGORI = ModEntities.registerAnimalWithSpawnEgg("Blagori", () -> WyRegistry.createEntityType(BlagoriEntity::new, EntityClassification.CREATURE).func_220321_a(1.0f, 1.5f).func_206830_a("mineminenomi:blagori"));
    public static final RegistryObject<EntityType<KungFuDugongEntity>> KUNG_FU_DUGONG = ModEntities.registerAnimalWithSpawnEgg("Kung Fu Dugong", () -> WyRegistry.createEntityType(KungFuDugongEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 1.2f).func_206830_a("mineminenomi:kung_fu_dugong"));
    public static final RegistryObject<EntityType<WrestlingDugongEntity>> WRESTLING_DUGONG = ModEntities.registerAnimalWithSpawnEgg("Wrestling Dugong", () -> WyRegistry.createEntityType(WrestlingDugongEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 1.2f).func_206830_a("mineminenomi:wrestling_dugong"));
    public static final RegistryObject<EntityType<BoxingDugongEntity>> BOXING_DUGONG = ModEntities.registerAnimalWithSpawnEgg("Boxing Dugong", () -> WyRegistry.createEntityType(BoxingDugongEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 1.2f).func_206830_a("mineminenomi:boxing_dugong"));
    public static final RegistryObject<EntityType<LegendaryMasterDugongEntity>> LEGENDARY_MASTER_DUGONG = ModEntities.registerAnimalWithSpawnEgg("Legendary Master Dugong", () -> WyRegistry.createEntityType(LegendaryMasterDugongEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 1.2f).func_206830_a("mineminenomi:legendary_master_dugong"));
    public static final RegistryObject<EntityType<WanderingDugongEntity>> WANDERING_DUGONG = ModEntities.registerAnimalWithSpawnEgg("Wandering Dugong", () -> WyRegistry.createEntityType(WanderingDugongEntity::new, EntityClassification.CREATURE).func_220321_a(0.6f, 1.2f).func_206830_a("mineminenomi:wandering_dugong"));
    public static final RegistryObject<EntityType<WantedPosterPackageEntity>> WANTED_POSTER_PACKAGE = WyRegistry.registerEntityType("Wanted Poster Package", () -> WyRegistry.createEntityType(WantedPosterPackageEntity::new).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:wanted_poster_package"));
    public static final RegistryObject<EntityType<VivreCardEntity>> VIVRE_CARD = WyRegistry.registerEntityType("Vivre Card", () -> WyRegistry.createEntityType(VivreCardEntity::new).func_220321_a(0.4f, 0.4f).func_206830_a("mineminenomi:vivre_card"));
    public static final RegistryObject<EntityType<PhysicalBodyEntity>> PHYSICAL_BODY = WyRegistry.registerEntityType("Physical Body", () -> WyRegistry.createEntityType(PhysicalBodyEntity::new).func_206830_a("mineminenomi:physical_body"));
    public static final RegistryObject<EntityType<SniperTargetEntity>> SNIPER_TARGET = WyRegistry.registerEntityType("Sniper Target", () -> WyRegistry.createEntityType(SniperTargetEntity::new).func_206830_a("mineminenomi:sniper_target"));
    public static final RegistryObject<EntityType<BombEntity>> BOMB = WyRegistry.registerEntityType("Bomb", () -> WyRegistry.createEntityType(BombEntity::new).func_220321_a(0.8f, 0.8f).func_206830_a("mineminenomi:bomb"));
    public static final RegistryObject<EntityType<DFItemEntity>> DEVIL_FRUIT_ITEM = WyRegistry.registerEntityType("Devil Fruit", () -> WyRegistry.createEntityType(DFItemEntity::new).func_220321_a(0.25f, 0.25f).func_206830_a("mineminenomi:df_item"));
    public static final RegistryObject<EntityType<SpikeEntity>> SPIKE = WyRegistry.registerEntityType("Spike", () -> WyRegistry.createEntityType(SpikeEntity::new).func_220321_a(0.2f, 0.2f).func_206830_a("mineminenomi:spike"));
    public static final RegistryObject<EntityType<BottomHalfBodyEntity>> BOTTOM_HALF_BODY = WyRegistry.registerEntityType("Bottom Half Body", () -> WyRegistry.createEntityType(BottomHalfBodyEntity::new).func_220321_a(0.6f, 0.9f).func_206830_a("mineminenomi:bottom_half_body"));
    public static final RegistryObject<EntityType<EntityCollectorEntity>> ENTITY_COLLECTOR = WyRegistry.registerEntityType("Entity Collector", () -> WyRegistry.createEntityType(EntityCollectorEntity::new).func_220321_a(1.0f, 1.0f).func_206830_a("mineminenomi:entity_collector"));
    public static final RegistryObject<EntityType<TornadoEntity>> TORNADO = WyRegistry.registerEntityType("Tornado", () -> WyRegistry.createEntityType(TornadoEntity::new).func_220321_a(1.5f, 3.0f).func_206830_a("mineminenomi:tornado"));
    public static final RegistryObject<EntityType<NetEntity>> ROPE_NET = WyRegistry.registerEntityType("Rope Net", () -> WyRegistry.createEntityType(NetEntity::new).func_220321_a(1.2f, 0.5f).func_206830_a("mineminenomi:rope_net"));
    public static final RegistryObject<EntityType<NetEntity>> KAIROSEKI_NET = WyRegistry.registerEntityType("Kairoseki Net", () -> WyRegistry.createEntityType(NetEntity::new).func_220321_a(1.2f, 0.5f).func_206830_a("mineminenomi:kairoseki_net"));
    public static final RegistryObject<EntityType<SphereEntity>> SPHERE = WyRegistry.registerEntityType("Sphere", () -> WyRegistry.createEntityType(SphereEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("mineminenomi:sphere"));
    public static final RegistryObject<EntityType<BonChariEntity>> BON_CHARI = WyRegistry.registerEntityType("Bon Chari", () -> WyRegistry.createEntityType(BonChariEntity::new).func_220321_a(1.5f, 1.5f).func_233606_a_(10).func_206830_a("mineminenomi:bon_chari"));
    public static final RegistryObject<EntityType<CannonEntity>> CANNON = WyRegistry.registerEntityType("Cannon", () -> WyRegistry.createEntityType(CannonEntity::new).func_220321_a(1.25f, 1.25f).func_233606_a_(10).func_206830_a("mineminenomi:cannot"));
    public static final RegistryObject<EntityType<StrikerEntity>> STRIKER = WyRegistry.registerEntityType("Striker", () -> WyRegistry.createEntityType(StrikerEntity::new).func_220321_a(1.75f, 0.5625f).func_233606_a_(10).func_206830_a("mineminenomi:striker"));
    public static final RegistryObject<EntityType<UnicycleEntity>> UNICYCLE = WyRegistry.registerEntityType("Unicycle", () -> WyRegistry.createEntityType(UnicycleEntity::new).func_220321_a(0.75f, 0.75f).func_233606_a_(10).func_206830_a("mineminenomi:unicycle"));
    public static final RegistryObject<EntityType<ThrowingWeaponEntity>> THROWING_WEAPON = WyRegistry.registerEntityType("Throwing Knife", () -> WyRegistry.createEntityType(ThrowingWeaponEntity::new).func_220321_a(1.0f, 1.0f).func_206830_a("mineminenomi:throwing_knife"));
    public static final RegistryObject<EntityType<SpearEntity>> THROWING_SPEAR = WyRegistry.registerEntityType("Throwing Spear", () -> WyRegistry.createEntityType(SpearEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("mineminenomi:throwing_spear"));
    public static final RegistryObject<EntityType<ChakramEntity>> CHAKRAM = WyRegistry.registerEntityType("Chakram", () -> WyRegistry.createEntityType(ChakramEntity::new).func_220321_a(0.75f, 0.5f).func_206830_a("mineminenomi:chakram"));
    public static final RegistryObject<EntityType<DummyEntity>> DUMMY_NEW_PHOENIX = WyRegistry.registerEntityType("Dummy: New Phoenix", () -> WyRegistry.createEntityType(DummyEntity::new).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:dummy_new_phoenix"));
    public static final RegistryObject<EntityType<DummyEntity>> DUMMY_CABAJI = WyRegistry.registerEntityType("Dummy Cabaji", () -> WyRegistry.createEntityType(CabajiDummyEntity::new).func_206830_a("mineminenomi:dummy_cabaji"));
    public static final RegistryObject<EntityType<DummyEntity>> DUMMY_JANGO = WyRegistry.registerEntityType("Dummy: Jango", () -> WyRegistry.createEntityType(JangoDummyEntity::new).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:dummy_jango"));
    public static final RegistryObject<EntityType<DummyEntity>> DUMMY_ALVIDA_SLIM = WyRegistry.registerEntityType("Dummy: Alvida Slim", () -> WyRegistry.createEntityType(DummyEntity::new).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:dummy_alvida_slim"));
    public static final RegistryObject<EntityType<DummyEntity>> DUMMY_NOTORIOUS = WyRegistry.registerEntityType("Dummy: Notorious", () -> WyRegistry.createEntityType(DummyEntity::new).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:dummy_notorious"));
    public static final RegistryObject<EntityType<DummyEntity>> DUMMY_BARKEEPER = WyRegistry.registerEntityType("Dummy: Barkeeper", () -> WyRegistry.createEntityType(DummyEntity::new).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:dummy_barkeeper"));
    public static final RegistryObject<EntityType<DummyEntity>> DUMMY_FLYING_FISH = WyRegistry.registerEntityType("Dummy: Flying Fish", () -> WyRegistry.createEntityType(FlyingFishDummyEntity::new).func_220321_a(1.5f, 1.5f).func_206830_a("mineminenomi:dummy_flying_fish"));

    private static <T extends Entity> RegistryObject<EntityType<T>> registerMarineWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = WyRegistry.registerEntityType(name, supp);
        WyRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, WyHelper.hexToRGB("#024a81").getRGB(), WyHelper.hexToRGB("#F7F7F7").getRGB(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerWorldGovWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = WyRegistry.registerEntityType(name, supp);
        WyRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, 0xBDBDBD, 0x2F2F2F, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerPirateWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = WyRegistry.registerEntityType(name, supp);
        WyRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, WyHelper.hexToRGB("#c11c1c").getRGB(), WyHelper.hexToRGB("#F7F7F7").getRGB(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerBanditWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = WyRegistry.registerEntityType(name, supp);
        WyRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, WyHelper.hexToRGB("#785355").getRGB(), WyHelper.hexToRGB("#F7F7F7").getRGB(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerFactionlessWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = WyRegistry.registerEntityType(name, supp);
        WyRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, WyHelper.hexToRGB("#fbbf4c").getRGB(), WyHelper.hexToRGB("#F7F7F7").getRGB(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerAnimalWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = WyRegistry.registerEntityType(name, supp);
        WyRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, WyHelper.hexToRGB("#a7ca34").getRGB(), WyHelper.hexToRGB("#a2f7c8").getRGB(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerDummyWithSpawnEgg(String name, Supplier<EntityType<T>> supp) {
        RegistryObject reg = WyRegistry.registerEntityType(name, supp);
        WyRegistry.registerSpawnEggItem(name, () -> new ForgeSpawnEggItem((Supplier)reg, WyHelper.hexToRGB("#FF00DD").getRGB(), WyHelper.hexToRGB("#EEFF00").getRGB(), new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        return reg;
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)MARINE_GRUNT.get(), GruntEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MARINE_BRUTE.get(), BruteEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MARINE_CAPTAIN.get(), CaptainEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MARINE_SNIPER.get(), SniperEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MARINE_TRADER.get(), MarineTraderEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PACIFISTA.get(), PacifistaEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MARINE_VICE_ADMIRAL.get(), NotoriousEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MORGAN.get(), MorganEntity.createAttributes().func_233813_a_());
        event.put((EntityType)CELESTIAL_DRAGON.get(), CelestialDragonEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PIRATE_GRUNT.get(), GruntEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PIRATE_BRUTE.get(), BruteEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PIRATE_CAPTAIN.get(), CaptainEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PIRATE_TRADER.get(), PirateTraderEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PIRATE_BOMBER.get(), PirateBomberEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PIRATE_NOTORIOUS_CAPTAIN.get(), NotoriousEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BUGGY.get(), BuggyEntity.createAttributes().func_233813_a_());
        event.put((EntityType)ALVIDA.get(), AlvidaEntity.createAttributes().func_233813_a_());
        event.put((EntityType)ALVIDA_SLIM.get(), AlvidaEntity.createAttributes().func_233813_a_());
        event.put((EntityType)CABAJI.get(), CabajiEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SHAM.get(), ShamEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BUCHI.get(), BuchiEntity.createAttributes().func_233813_a_());
        event.put((EntityType)JANGO.get(), JangoEntity.createAttributes().func_233813_a_());
        event.put((EntityType)KURO.get(), KuroEntity.createAttributes().func_233813_a_());
        event.put((EntityType)GIN.get(), GinEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PEARL.get(), PearlEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DON_KRIEG.get(), DonKriegEntity.createAttributes().func_233813_a_());
        event.put((EntityType)CHEW.get(), ChewEntity.createAttributes().func_233813_a_());
        event.put((EntityType)KUROOBI.get(), KuroobiEntity.createAttributes().func_233813_a_());
        event.put((EntityType)ARLONG.get(), ArlongEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MR5.get(), Mr5Entity.createAttributes().func_233813_a_());
        event.put((EntityType)MISS_VALENTINE.get(), MissValentineEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MR4.get(), Mr4Entity.createAttributes().func_233813_a_());
        event.put((EntityType)MISS_MERRY_CHRISTMAS.get(), MissMerryChristmasEntity.createAttributes().func_233813_a_());
        event.put((EntityType)MR3.get(), Mr3Entity.createAttributes().func_233813_a_());
        event.put((EntityType)MR1.get(), Mr1Entity.createAttributes().func_233813_a_());
        event.put((EntityType)MR0.get(), Mr0Entity.createAttributes().func_233813_a_());
        event.put((EntityType)BANDIT_GRUNT.get(), GruntEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BANDIT_BRUTE.get(), BruteEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BANDIT_SNIPER.get(), SniperEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BANDIT_CAPTAIN.get(), CaptainEntity.createAttributes().func_233813_a_());
        event.put((EntityType)HIGUMA.get(), HigumaEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SWORDSMAN_TRAINER.get(), SwordsmanTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SNIPER_TRAINER.get(), SniperTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DOCTOR_TRAINER.get(), DoctorTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)ART_OF_WEATHER_TRAINER.get(), ArtOfWeatherTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BRAWLER_TRAINER.get(), BrawlerTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BLACK_LEG_TRAINER.get(), BlackLegTrainerEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SKYPIEAN_CIVILIAN.get(), SkypieanCivilianEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SKYPIEAN_TRADER.get(), SkypieanTraderEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BARKEEPER.get(), BarkeeperEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DEN_DEN_MUSHI.get(), DenDenMushiEntity.createAttributes().func_233813_a_());
        event.put((EntityType)LAPAHN.get(), LapahnEntity.createAttributes().func_233813_a_());
        event.put((EntityType)YAGARA_BULL.get(), YagaraBullEntity.createAttributes().func_233813_a_());
        event.put((EntityType)HUMANDRILL.get(), HumandrillEntity.createAttributes().func_233813_a_());
        event.put((EntityType)FIGHTING_FISH.get(), FightingFishEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BANANAWANI.get(), BananawaniEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BIG_DUCK.get(), BigDuckEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SEA_COW.get(), SeaCowEntity.createAttributes().func_233813_a_());
        event.put((EntityType)WHITE_WALKIE.get(), WhiteWalkieEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PANDA_SHARK.get(), PandaSharkEntity.createAttributes().func_233813_a_());
        event.put((EntityType)FLYING_FISH.get(), FlyingFishEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BLUGORI.get(), BlugoriEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BLAGORI.get(), BlagoriEntity.createAttributes().func_233813_a_());
        event.put((EntityType)KUNG_FU_DUGONG.get(), KungFuDugongEntity.createAttributes().func_233813_a_());
        event.put((EntityType)WRESTLING_DUGONG.get(), WrestlingDugongEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BOXING_DUGONG.get(), BoxingDugongEntity.createAttributes().func_233813_a_());
        event.put((EntityType)LEGENDARY_MASTER_DUGONG.get(), LegendaryMasterDugongEntity.createAttributes().func_233813_a_());
        event.put((EntityType)WANDERING_DUGONG.get(), WanderingDugongEntity.createAttributes().func_233813_a_());
        event.put((EntityType)WANTED_POSTER_PACKAGE.get(), WantedPosterPackageEntity.func_233666_p_().func_233813_a_());
        event.put((EntityType)PHYSICAL_BODY.get(), PhysicalBodyEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SNIPER_TARGET.get(), SniperTargetEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BOTTOM_HALF_BODY.get(), BottomHalfBodyEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DUMMY_NEW_PHOENIX.get(), OPEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DUMMY_CABAJI.get(), OPEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DUMMY_JANGO.get(), OPEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DUMMY_ALVIDA_SLIM.get(), OPEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DUMMY_NOTORIOUS.get(), OPEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DUMMY_BARKEEPER.get(), OPEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DUMMY_FLYING_FISH.get(), OPEntity.createAttributes().func_233813_a_());
    }

    public static void setupSpawnRules() {
        if (((Boolean)WorldEventsConfig.SPAWN_WORLD_HUMANOIDS.get()).booleanValue()) {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)MARINE_GRUNT.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GruntEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)MARINE_BRUTE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BruteEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)MARINE_SNIPER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SniperEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)MARINE_CAPTAIN.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CaptainEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)MARINE_TRADER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, OPEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PACIFISTA.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PacifistaEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)MARINE_VICE_ADMIRAL.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, OPEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PIRATE_GRUNT.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GruntEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PIRATE_BRUTE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BruteEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PIRATE_CAPTAIN.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, CaptainEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PIRATE_TRADER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, OPEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PIRATE_BOMBER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BruteEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PIRATE_NOTORIOUS_CAPTAIN.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, OPEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BANDIT_GRUNT.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GruntEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BANDIT_SNIPER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SniperEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BANDIT_BRUTE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BruteEntity::checkSpawnRules);
        }
        if (((Boolean)WorldEventsConfig.SPAWN_WORLD_ANIMALS.get()).booleanValue()) {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)DEN_DEN_MUSHI.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)LAPAHN.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)YAGARA_BULL.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, YagaraBullEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)HUMANDRILL.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.PlacementType ffPlacement = WyHelper.isAprilFirst() ? EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS : EntitySpawnPlacementRegistry.PlacementType.IN_WATER;
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)FIGHTING_FISH.get()), (EntitySpawnPlacementRegistry.PlacementType)ffPlacement, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FightingFishEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BANANAWANI.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BIG_DUCK.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WHITE_WALKIE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PANDA_SHARK.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PandaSharkEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)FLYING_FISH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FlyingFishEntity::checkSpawnRules);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BLUGORI.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BLAGORI.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)KUNG_FU_DUGONG.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WRESTLING_DUGONG.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BOXING_DUGONG.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)LEGENDARY_MASTER_DUGONG.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)WANDERING_DUGONG.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        }
    }

    public static void setupCategorySpawns(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)key);
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_());
        if (((Boolean)WorldEventsConfig.SPAWN_WORLD_HUMANOIDS.get()).booleanValue()) {
            if (MARINE_BIOMES.stream().anyMatch(type -> types.contains(type))) {
                event.getSpawns().func_242575_a(MARINES, new MobSpawnInfo.Spawners((EntityType)MARINE_GRUNT.get(), 940, 2, 4)).func_242577_b();
                event.getSpawns().func_242575_a(MARINES, new MobSpawnInfo.Spawners((EntityType)MARINE_BRUTE.get(), 50, 1, 2)).func_242577_b();
                event.getSpawns().func_242575_a(MARINES, new MobSpawnInfo.Spawners((EntityType)MARINE_SNIPER.get(), 10, 1, 1)).func_242577_b();
                event.getSpawns().func_242575_a(MARINES, new MobSpawnInfo.Spawners((EntityType)PACIFISTA.get(), 1, 1, 1)).func_242577_b();
            }
            if (PIRATE_BIOMES.stream().anyMatch(type -> types.contains(type))) {
                event.getSpawns().func_242575_a(PIRATES, new MobSpawnInfo.Spawners((EntityType)PIRATE_GRUNT.get(), 96, 2, 4)).func_242577_b();
                event.getSpawns().func_242575_a(PIRATES, new MobSpawnInfo.Spawners((EntityType)PIRATE_BRUTE.get(), 2, 1, 2)).func_242577_b();
                event.getSpawns().func_242575_a(PIRATES, new MobSpawnInfo.Spawners((EntityType)PIRATE_BOMBER.get(), 2, 1, 1)).func_242577_b();
            }
            if (BANDIT_BIOMES.stream().anyMatch(type -> types.contains(type))) {
                event.getSpawns().func_242575_a(BANDITS, new MobSpawnInfo.Spawners((EntityType)BANDIT_GRUNT.get(), 94, 1, 4)).func_242577_b();
                event.getSpawns().func_242575_a(BANDITS, new MobSpawnInfo.Spawners((EntityType)BANDIT_BRUTE.get(), 5, 1, 2)).func_242577_b();
                event.getSpawns().func_242575_a(BANDITS, new MobSpawnInfo.Spawners((EntityType)BANDIT_SNIPER.get(), 1, 1, 1)).func_242577_b();
            }
        }
        if (((Boolean)WorldEventsConfig.SPAWN_WORLD_ANIMALS.get()).booleanValue()) {
            if (biome == ModBiomes.RAIGO.get()) {
                return;
            }
            if (types.contains(BiomeDictionary.Type.PLAINS) || types.contains(BiomeDictionary.Type.HILLS) || types.contains(BiomeDictionary.Type.BEACH) || types.contains(BiomeDictionary.Type.SWAMP)) {
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)DEN_DEN_MUSHI.get(), 8, 1, 4)).func_242577_b();
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)BIG_DUCK.get(), 5, 1, 3)).func_242577_b();
            }
            if (types.contains(BiomeDictionary.Type.COLD) || types.contains(BiomeDictionary.Type.SNOWY)) {
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)LAPAHN.get(), 8, 1, 3)).func_242577_b();
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WHITE_WALKIE.get(), 5, 1, 1)).func_242577_b();
            }
            if (types.contains(BiomeDictionary.Type.BEACH) || types.contains(BiomeDictionary.Type.OCEAN)) {
                event.getSpawns().func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)YAGARA_BULL.get(), 8, 2, 3)).func_242577_b();
                event.getSpawns().func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)SEA_COW.get(), 1, 1, 1)).func_242577_b();
            }
            if (types.contains(BiomeDictionary.Type.OCEAN) && !types.contains(BiomeDictionary.Type.COLD)) {
                event.getSpawns().func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)PANDA_SHARK.get(), 4, 1, 2)).func_242577_b();
                int ffWeight = WyHelper.isAprilFirst() ? 10 : 1;
                event.getSpawns().func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)FIGHTING_FISH.get(), ffWeight, 1, 1)).func_242577_b();
            }
            if (types.contains(BiomeDictionary.Type.SWAMP) || biome == ModBiomes.SABAODY.get()) {
                event.getSpawns().func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)FLYING_FISH.get(), 4, 1, 2)).func_242577_b();
            }
            if ((types.contains(BiomeDictionary.Type.BEACH) || types.contains(BiomeDictionary.Type.SANDY)) && !types.contains(BiomeDictionary.Type.PLATEAU)) {
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)BANANAWANI.get(), 7, 1, 2)).func_242577_b();
            }
            if (types.contains(BiomeDictionary.Type.FOREST) || types.contains(BiomeDictionary.Type.JUNGLE)) {
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)HUMANDRILL.get(), 8, 1, 3)).func_242577_b();
            }
            if (types.contains(BiomeDictionary.Type.COLD) && types.contains(BiomeDictionary.Type.FOREST)) {
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)BLUGORI.get(), 8, 1, 3)).func_242577_b();
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)BLAGORI.get(), 3, 1, 1)).func_242577_b();
            }
            if (types.contains(BiomeDictionary.Type.BEACH) || types.contains(BiomeDictionary.Type.SANDY)) {
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)KUNG_FU_DUGONG.get(), 12, 3, 5)).func_242577_b();
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)BOXING_DUGONG.get(), 7, 1, 3)).func_242577_b();
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WRESTLING_DUGONG.get(), 7, 1, 3)).func_242577_b();
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)LEGENDARY_MASTER_DUGONG.get(), 2, 1, 1)).func_242577_b();
            }
            if (types.contains(BiomeDictionary.Type.BEACH) || types.contains(BiomeDictionary.Type.FOREST) || types.contains(BiomeDictionary.Type.SWAMP) || types.contains(BiomeDictionary.Type.PLAINS)) {
                event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WANDERING_DUGONG.get(), 2, 1, 1)).func_242577_b();
            }
        }
    }

    public static void register(IEventBus eventBus) {
        WyRegistry.ENTITY_TYPES.register(eventBus);
    }
}

