/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.passives;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.yomi.YomiNoReikiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.events.ability.YomiTriggerEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.models.morphs.YomiModel;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.renderers.morphs.ZoanMorphRenderer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class YomiPassiveEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD && props.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) && ((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive((LivingEntity)player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            IDevilFruit oldPlayerProps = DevilFruitCapability.get((LivingEntity)event.getOriginal());
            IDevilFruit newPlayerProps = DevilFruitCapability.get((LivingEntity)event.getPlayer());
            YomiTriggerEvent yomiEvent = new YomiTriggerEvent(event.getPlayer(), oldPlayerProps, newPlayerProps);
            MinecraftForge.EVENT_BUS.post((Event)yomiEvent);
            if (event.getPlayer() instanceof ServerPlayerEntity) {
                ModAdvancements.YOMI_REVIVE.trigger((ServerPlayerEntity)event.getOriginal());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        boolean isRunning;
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        if (!devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || !((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive((LivingEntity)player)) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            if (player.func_71024_bL().func_75116_a() <= 18) {
                player.func_71024_bL().func_75114_a(18);
            }
            player.func_195064_c(new EffectInstance(Effects.field_76424_c, 10, player.func_70051_ag() ? 4 : 0, false, false));
            if (player.field_70173_aa % 500 == 0) {
                WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), player);
                WyNetwork.sendToAllAround(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), (Entity)player);
            }
        }
        BlockState state = player.field_70170_p.func_180495_p(player.func_233580_cy_().func_177977_b());
        boolean bl = isRunning = Math.abs(player.func_213322_ci().field_72450_a) >= 0.15 || Math.abs(player.func_213322_ci().field_72449_c) >= 0.15;
        if (state.func_204520_s().func_206889_d() && state.func_185904_a().equals(Material.field_151586_h) && isRunning) {
            Vector3d moveVec = player.func_70040_Z().func_72432_b().func_216372_d(0.5, 0.0, 0.5);
            if ((double)player.field_191988_bg == 0.0) {
                return;
            }
            AbilityHelper.setDeltaMovement((Entity)player, moveVec);
            player.field_70143_R = 0.0f;
            if (!player.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double newPosX = player.func_226277_ct_() + WyHelper.randomDouble();
                    double newPosY = player.func_226278_cu_();
                    double newPosZ = player.func_226281_cx_() + WyHelper.randomDouble();
                    ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), newPosX, newPosY, newPosZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        if (!devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || !((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive((LivingEntity)player)) {
            return;
        }
        event.setAmount(event.getAmount());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityRendered(RenderLivingEvent.Pre event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!YomiPassiveEvents.isSpirit(player)) {
            return;
        }
        MorphInfo info = MorphHelper.getZoanInfo((LivingEntity)player);
        if (info == null) {
            return;
        }
        ZoanMorphRenderer render = (ZoanMorphRenderer)info.getRendererFactory().createRenderFor(Minecraft.func_71410_x().func_175598_ae());
        IVertexBuilder vertex = event.getBuffers().getBuffer(RenderType.func_228644_e_((ResourceLocation)render.func_110775_a((AbstractClientPlayerEntity)player)));
        event.setCanceled(true);
        event.getMatrixStack().func_227860_a_();
        event.getMatrixStack().func_227861_a_(0.0, 1.5, 0.0);
        event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 180.0f, true));
        event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
        event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229181_d_, player.field_70126_B + (player.field_70177_z - player.field_70126_B) * event.getPartialRenderTick() - 180.0f, true));
        event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229179_b_, player.field_70127_C + (player.field_70125_A - player.field_70127_C) * event.getPartialRenderTick(), true));
        ((YomiModel)render.func_217764_d()).field_78116_c.func_228309_a_(event.getMatrixStack(), vertex, event.getLight(), OverlayTexture.field_229196_a_, 0.3f, 0.9f, 0.5f, 0.6f);
        event.getMatrixStack().func_227860_a_();
        IVertexBuilder vertexBuilder = event.getBuffers().getBuffer(RenderType.func_228657_l_());
        event.getMatrixStack().func_227861_a_(0.0, -0.35, 0.0);
        float randMovement = ((float)(player.field_70173_aa / 200) + event.getPartialRenderTick()) / 500.0f;
        for (int i = 0; i < 100; ++i) {
            event.getMatrixStack().func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(player.func_70681_au().nextFloat() * 360.0f + randMovement * 90.0f));
            float f3 = 0.6f * player.func_70681_au().nextFloat();
            float f4 = 0.6f * player.func_70681_au().nextFloat();
            Matrix4f matrix4f = event.getMatrixStack().func_227866_c_().func_227870_a_();
            int alpha = 5;
            Color primaryColor = new Color(0, 255, 0, alpha);
            Color secondaryColor = new Color(0, 255, 50, alpha);
            RendererHelper.drawA(vertexBuilder, matrix4f, primaryColor);
            RendererHelper.drawB(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawC(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawA(vertexBuilder, matrix4f, primaryColor);
            RendererHelper.drawC(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawD(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawA(vertexBuilder, matrix4f, primaryColor);
            RendererHelper.drawD(vertexBuilder, matrix4f, f3, f4, secondaryColor);
            RendererHelper.drawB(vertexBuilder, matrix4f, f3, f4, secondaryColor);
        }
        event.getMatrixStack().func_227865_b_();
        event.getMatrixStack().func_227865_b_();
    }

    @SubscribeEvent
    public static void onDrinkMilk(LivingEntityUseItemEvent.Finish event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        IDevilFruit devilFruitProps = DevilFruitCapability.get(event.getEntityLiving());
        if (!devilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI)) {
            return;
        }
        if (event.getItem().func_77973_b() == Items.field_151117_aB && ((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive(event.getEntityLiving())) {
            event.getEntityLiving().func_70691_i(8.0f);
        }
    }

    private static boolean isSpirit(PlayerEntity player) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        if (abilityProps == null) {
            return false;
        }
        if (player.func_184812_l_() || player.func_175149_v()) {
            return false;
        }
        YomiNoReikiAbility ability = abilityProps.getEquippedAbility(YomiNoReikiAbility.INSTANCE);
        if (ability == null) {
            return false;
        }
        Optional<ContinuousComponent> comp = ability.getComponent(ModAbilityKeys.CONTINUOUS);
        return comp.isPresent() && comp.get().isContinuous();
    }
}

