/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.passives;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.doa.AirDoorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class DoaPassiveEvents {
    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onItemTossed(ItemTossEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
        player.func_191521_c(event.getEntityItem().func_92059_d());
    }

    @SubscribeEvent
    public static void onEntityHits(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityLeftClickBlocks(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityRightClickBlocks(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityBreaksBlocks(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityPlaceBlocks(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!DoaPassiveEvents.isInsideDoor(player)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        if (!(event.getTarget() instanceof PlayerEntity) || event.getTarget() instanceof FakePlayer || !(event.getEntity() instanceof MobEntity)) {
            return;
        }
        if (!DoaPassiveEvents.isInsideDoor((PlayerEntity)event.getTarget())) {
            return;
        }
        MobEntity entity = (MobEntity)event.getEntity();
        entity.func_70624_b(null);
    }

    public static boolean isInsideDoor(PlayerEntity player) {
        boolean isActive;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        if (abilityProps == null) {
            return false;
        }
        Ability ability = abilityProps.getEquippedAbility(AirDoorAbility.INSTANCE);
        boolean bl = isActive = ability != null && ability.isContinuous();
        return isActive;
    }

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void onPlayerCameraSetup(EntityViewRenderEvent.CameraSetup event) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player.func_70644_a((Effect)ModEffects.DOOR_HEAD.get())) {
                event.setYaw((float)(player.field_70173_aa * 10) % 360.0f);
            }
        }

        @SubscribeEvent
        public static void onEntityRendered(RenderLivingEvent.Pre event) {
            LivingEntity entity = event.getEntity();
            if (entity.func_70644_a((Effect)ModEffects.DOOR_HEAD.get())) {
                entity.field_70761_aq = 0.0f;
                entity.field_70760_ar = 0.0f;
            }
        }

        @SubscribeEvent
        public static void onEntityRendered(RenderLivingEvent.Post event) {
            LivingEntity entity = event.getEntity();
            if (entity.func_70644_a((Effect)ModEffects.DOOR_HEAD.get())) {
                entity.field_70759_as += 10.0f;
                entity.field_70758_at += 10.0f;
                entity.field_70761_aq = 0.0f;
                entity.field_70760_ar = 0.0f;
            }
        }

        @SubscribeEvent
        public static void onFirstPersonViewRendered(TickEvent.RenderTickEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player == null || !player.func_70089_S()) {
                return;
            }
            if (!DoaPassiveEvents.isInsideDoor((PlayerEntity)player)) {
                return;
            }
            RendererHelper.drawColourOnScreen(WyHelper.hexToRGB("#2AFFAE").getRGB(), 50, 0.0, 0.0, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p(), 500.0);
        }
    }
}

