/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.abilities;

import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityProgressionEvents;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncChallengeDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class AbilityValidationEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
            IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
            IChallengesData challengesProps = ChallengesDataCapability.get(player);
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
            abilityProps.setCombatBarSet(0);
            entityStatsProps.setCombatMode(false);
            for (int bar = 0; bar < 10; ++bar) {
                if (bar < CommonConfig.INSTANCE.getAbilityBars()) continue;
                for (int slot = 0; slot < 8; ++slot) {
                    abilityProps.setEquippedAbility(slot + bar * 8, null);
                }
            }
            if (CommonConfig.INSTANCE.isAbilityFraudChecksEnabled()) {
                ItemStack dfStack = new ItemStack((IItemProvider)devilFruitProps.getDevilFruitItem());
                if (dfStack.func_77973_b() == Blocks.field_150350_a.func_199767_j()) {
                    devilFruitProps.setDevilFruit((ResourceLocation)null);
                }
                AbilityProgressionEvents.checkAllForNewUnlocks(player);
            }
            WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), entityStatsProps), player);
            WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), player);
            WyNetwork.sendTo(new SSyncHakiDataPacket(player.func_145782_y(), hakiProps), player);
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityProps), player);
            WyNetwork.sendTo(new SSyncChallengeDataPacket(player.func_145782_y(), challengesProps), player);
        }
    }

    public static boolean validateUnlockedAbilities(LivingEntity entity) {
        IAbilityData props = AbilityDataCapability.get(entity);
        long updates = props.getUnlockedAbilities().stream().map(wrapper -> wrapper.getAbilityCore()).map(core -> AbilityHelper.checkAndUnlockAbility(entity, core)).filter(b -> b).collect(Collectors.counting());
        return updates != 0L;
    }

    public static void checkForPossibleFruitAbilities(LivingEntity entity) {
        IDevilFruit devilFruitProps = DevilFruitCapability.get(entity);
        ItemStack df = new ItemStack((IItemProvider)devilFruitProps.getDevilFruitItem());
        if (!df.func_190926_b()) {
            for (AbilityCore core : ((AkumaNoMiItem)df.func_77973_b()).getAbilities()) {
                AbilityHelper.checkAndUnlockAbility(entity, core);
            }
        }
    }
}

