/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingAttackEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingDamageEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingHurtEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class DamageSourceEvents {
    @SubscribeEvent
    public static void onEntityAttackEvent(WyLivingAttackEvent event) {
        if (!CommonConfig.INSTANCE.isSpecialSourceEventsEnabled()) {
            return;
        }
        Entity attacker = event.getSource().func_76364_f();
        LivingEntity entity = event.getEntityLiving();
        if (attacker instanceof OPEntity && ((OPEntity)attacker).hasBusoHaki()) {
            Item mainShield = entity.func_184614_ca().func_77973_b();
            Item secondaryShield = entity.func_184592_cb().func_77973_b();
            if (entity instanceof PlayerEntity && Math.random() > 0.5 && (mainShield.equals(Items.field_185159_cQ) || secondaryShield.equals(Items.field_185159_cQ))) {
                ((PlayerEntity)entity).func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                entity.func_184602_cy();
                entity.field_70170_p.func_72960_a(attacker, (byte)30);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDamageEvent(WyLivingAttackEvent event) {
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || !(source instanceof ModDamageSource) || entity.func_70644_a((Effect)ModEffects.GUARDING.get())) {
            return;
        }
        switch (source.func_76355_l()) {
            case "lava": {
                if (!CommonConfig.INSTANCE.isSpecialSourceEventsEnabled() || !(source.func_76346_g() instanceof PlayerEntity)) {
                    return;
                }
                entity.func_195063_d(Effects.field_76426_n);
                break;
            }
            case "onFire": {
                if (!CommonConfig.INSTANCE.isSpecialSourceEventsEnabled() || !(source.func_76346_g() instanceof PlayerEntity)) {
                    return;
                }
                AbilityHelper.reduceEffect(entity.func_70660_b((Effect)ModEffects.FROZEN.get()), 2.0);
                AbilityHelper.reduceEffect(entity.func_70660_b(Effects.field_76426_n), 2.0);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDamage(WyLivingDamageEvent event) {
        if (event.getAmount() <= 0.0f) {
            return;
        }
        LivingEntity living = event.getEntityLiving();
        if (living.func_70644_a((Effect)ModEffects.DRUNK.get())) {
            IEntityStats props = EntityStatsCapability.get(living);
            float storedDamage = props.getStoredDamage() + event.getAmount();
            props.setStoredDamage(storedDamage);
            living.func_70691_i(event.getAmount());
        }
    }

    @SubscribeEvent
    public static void onEntityHurtEvent(WyLivingHurtEvent event) {
        DamageSource source = event.getSource();
        LivingEntity entity = event.getEntityLiving();
        Entity attacker = source.func_76364_f();
        float amount = event.getAmount();
        if (entity.field_70170_p.field_72995_K || event.getAmount() <= 0.0f) {
            return;
        }
        if (source.func_76355_l().equals("lightningBolt") || source.func_76355_l().equals("lava") || source.func_76355_l().equals("onFire") || source.func_76355_l().equals("inFire")) {
            if (entity.func_70644_a((Effect)ModEffects.FROZEN.get())) {
                AbilityHelper.reduceEffect(entity.func_70660_b((Effect)ModEffects.FROZEN.get()), 2.0);
                entity.func_70066_B();
                return;
            }
            if (entity.func_70644_a((Effect)ModEffects.FROSTBITE.get())) {
                entity.func_195063_d((Effect)ModEffects.FROSTBITE.get());
                entity.func_70066_B();
            }
            if (entity.func_70644_a((Effect)ModEffects.CANDLE_LOCK.get())) {
                entity.func_195063_d((Effect)ModEffects.CANDLE_LOCK.get());
                entity.func_70066_B();
            }
            if (entity.func_70644_a((Effect)ModEffects.CANDY_STUCK.get())) {
                entity.func_195063_d((Effect)ModEffects.CANDY_STUCK.get());
                entity.func_70066_B();
            }
        }
        if (event.getSource().func_76364_f() instanceof PlayerEntity) {
            // empty if block
        }
    }
}

