/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.api.events.SmithingTableEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEnchantments;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.DFEncyclopediaItem;
import xyz.pixelatedw.mineminenomi.items.FlagItem;
import xyz.pixelatedw.mineminenomi.items.WantedPosterItem;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class CraftingEvents {
    private static final ResourceLocation FLAG_UPGRADE_RECIPE = new ResourceLocation("mineminenomi", "flag_upgrade");
    private static final ResourceLocation WANTED_POSTER_UPGRADE_RECIPE = new ResourceLocation("mineminenomi", "wanted_poster_upgrade");
    private static final ResourceLocation ENCYCLOPEDIA_MERGE_RECIPE = new ResourceLocation("mineminenomi", "devil_fruit_encyclopedia_merge");

    public static boolean onGridChanged(int containerId, World level, PlayerEntity player, CraftingInventory container, CraftResultInventory resultContainer) {
        if (!level.field_72995_K) {
            ServerPlayerEntity serverplayer = (ServerPlayerEntity)player;
            Optional optional = level.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)container, level);
            ItemStack stack = ItemStack.field_190927_a;
            if (optional.isPresent()) {
                ICraftingRecipe icraftingrecipe = (ICraftingRecipe)optional.get();
                if (icraftingrecipe.func_199560_c().equals((Object)FLAG_UPGRADE_RECIPE)) {
                    if (resultContainer.func_201561_a(level, serverplayer, (IRecipe)icraftingrecipe)) {
                        stack = container.func_70301_a(4).func_77946_l();
                        if ((stack = CraftingEvents.handleFlagUpgrades(stack)).func_190926_b()) {
                            return true;
                        }
                    }
                } else if (icraftingrecipe.func_199560_c().equals((Object)WANTED_POSTER_UPGRADE_RECIPE)) {
                    if (resultContainer.func_201561_a(level, serverplayer, (IRecipe)icraftingrecipe)) {
                        stack = container.func_70301_a(4).func_77946_l();
                        if ((stack = CraftingEvents.handleWantedPosterUpgrades(stack)).func_190926_b()) {
                            return true;
                        }
                    }
                } else if (icraftingrecipe.func_199560_c().equals((Object)ENCYCLOPEDIA_MERGE_RECIPE) && resultContainer.func_201561_a(level, serverplayer, (IRecipe)icraftingrecipe)) {
                    ItemStack stack2 = ItemStack.field_190927_a;
                    for (int i = 0; i < container.func_70302_i_(); ++i) {
                        ItemStack containerStack = container.func_70301_a(i);
                        if (containerStack.func_190926_b() || !containerStack.func_77973_b().equals(ModItems.DEVIL_FRUIT_ENCYCLOPEDIA.get())) continue;
                        if (stack.func_190926_b()) {
                            stack = containerStack.func_77946_l();
                            continue;
                        }
                        stack2 = containerStack;
                    }
                    if (!stack.func_190926_b() && !stack2.func_190926_b()) {
                        stack = CraftingEvents.handleEncyclopediaMerge(stack, stack2);
                    }
                }
                if (!stack.func_190926_b()) {
                    resultContainer.func_70299_a(0, stack);
                    serverplayer.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(containerId, 0, stack));
                    return true;
                }
            }
        }
        return false;
    }

    private static ItemStack handleEncyclopediaMerge(ItemStack output, ItemStack other) {
        for (DFEncyclopediaEntry entry : DFEncyclopediaItem.getEntries(other)) {
            DFEncyclopediaItem.addFruitClues(output, entry.getDevilFruit().getRegistryName(), entry);
        }
        return output;
    }

    private static ItemStack handleWantedPosterUpgrades(ItemStack output) {
        if (WantedPosterItem.upgradeCanvasSize(output)) {
            return output;
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack handleFlagUpgrades(ItemStack output) {
        if (FlagItem.upgradeCanvasSize(output)) {
            return output;
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public static void onSmithingUpdate(SmithingTableEvent event) {
        if (ItemsHelper.isBow(event.getBaseSlot())) {
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.FLAME_DIAL.get()).func_199767_j(), Enchantments.field_185311_w, 1, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.BREATH_DIAL.get()).func_199767_j(), Enchantments.field_185310_v, 1, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.EISEN_DIAL.get()).func_199767_j(), Enchantments.field_185309_u, 1, 3);
        } else if (ItemsHelper.isSword(event.getBaseSlot())) {
            CraftingEvents.applyEnchantment(event, (Item)ModItems.KAIROSEKI.get(), (Enchantment)ModEnchantments.KAIROSEKI.get(), 1, 10);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.FLAME_DIAL.get()).func_199767_j(), Enchantments.field_77334_n, 3, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.EISEN_DIAL.get()).func_199767_j(), Enchantments.field_185302_k, 3, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.FLASH_DIAL.get()).func_199767_j(), (Enchantment)ModEnchantments.DIAL_FLASH.get(), 3, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.IMPACT_DIAL.get()).func_199767_j(), (Enchantment)ModEnchantments.DIAL_IMPACT.get(), 2, 5);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.BREATH_DIAL.get()).func_199767_j(), Enchantments.field_180313_o, 3, 3);
        }
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151008_G, 1, 8, new ItemStack((IItemProvider)ModBlocks.BREATH_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151145_ak, 1, 10, new ItemStack((IItemProvider)ModBlocks.AXE_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151042_j, 1, 8, new ItemStack((IItemProvider)ModBlocks.EISEN_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151065_br, 1, 6, new ItemStack((IItemProvider)ModBlocks.FLAME_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151114_aO, 1, 10, new ItemStack((IItemProvider)ModBlocks.FLASH_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151016_H, 1, 10, new ItemStack((IItemProvider)ModBlocks.IMPACT_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)ModBlocks.SKY_BLOCK.get(), 1, 4, new ItemStack((IItemProvider)ModBlocks.MILKY_DIAL.get()));
    }

    private static void craftDial(SmithingTableEvent event, IItemProvider base, IItemProvider add, int baseQty, int addQty, ItemStack result) {
        if (event.getBaseSlot().func_77973_b().equals(base.func_199767_j()) && event.getBaseSlot().func_190916_E() >= baseQty && event.getAdditionSlot().func_77973_b().equals(add.func_199767_j()) && event.getAdditionSlot().func_190916_E() >= addQty) {
            event.setResultRecipe(result, baseQty, addQty);
        }
    }

    private static void applyEnchantment(SmithingTableEvent event, Item enchItem, Enchantment ench, int maxLevel, int addQty) {
        int enchLevel = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)event.getBaseSlot());
        if (enchLevel >= maxLevel) {
            return;
        }
        if (event.getAdditionSlot().func_77973_b() == enchItem && event.getAdditionSlot().func_190916_E() >= addQty && event.getAdditionSlot().func_190916_E() / addQty > enchLevel) {
            int level = event.getAdditionSlot().func_190916_E() / addQty;
            if (level > maxLevel) {
                level = maxLevel;
            }
            ItemStack stack = event.getBaseSlot().func_77946_l();
            Map map = EnchantmentHelper.func_82781_a((ItemStack)event.getBaseSlot());
            if (map.containsKey(ench)) {
                map.replace(ench, level);
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
            } else {
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
                stack.func_77966_a(ench, level);
            }
            event.setResultRecipe(stack, 1, addQty);
        }
    }
}

