/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.WantedPosterPackageEntity;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class BountyEvents {
    private static HashMap<PlayerEntity, double[]> cachedPositions = new HashMap();

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.SERVER || !CommonConfig.INSTANCE.isWantedPosterPackagesEnabled()) {
            return;
        }
        if (event.world.func_82737_E() % (long)CommonConfig.INSTANCE.getTimeBetweenPackages() == 0L) {
            BountyEvents.updateEverybodysBounty((ServerWorld)event.world);
            BountyEvents.dropWantedPosters((ServerWorld)event.world);
        }
        if (event.world.func_82737_E() % 60L * 20L * 60L == 0L) {
            cachedPositions.clear();
        }
    }

    private static void updateEverybodysBounty(ServerWorld world) {
        for (PlayerEntity player : world.func_217369_A()) {
            BountyHelper.issueBountyForPlayer(player);
        }
    }

    private static void dropWantedPosters(ServerWorld world) {
        int listSize = MathHelper.func_76125_a((int)(world.func_217369_A().size() / 2), (int)1, (int)10);
        PlayerEntity[] cachedPlayers = new PlayerEntity[listSize];
        for (int i = 0; i < cachedPlayers.length; ++i) {
            boolean alreadyCached;
            ServerPlayerEntity player = world.func_217472_l_();
            if (player == null || (alreadyCached = Arrays.stream(cachedPlayers).anyMatch(arg_0 -> BountyEvents.lambda$dropWantedPosters$0((PlayerEntity)player, arg_0)))) continue;
            double currentPosX = player.func_226277_ct_();
            double currentPosZ = player.func_226281_cx_();
            boolean drop = false;
            if (!cachedPositions.containsKey(player)) {
                cachedPositions.put((PlayerEntity)player, new double[]{currentPosX, currentPosZ});
                drop = true;
            } else {
                boolean flagPosZ;
                double[] positions = cachedPositions.get(player);
                double cachedPosX = positions[0];
                double cachedPosZ = positions[1];
                boolean flagPosX = Math.abs(currentPosX - cachedPosX) > 100.0;
                boolean bl = flagPosZ = Math.abs(currentPosZ - cachedPosZ) > 100.0;
                if (flagPosX || flagPosZ) {
                    cachedPositions.remove(player);
                    cachedPositions.put((PlayerEntity)player, new double[]{currentPosX, currentPosZ});
                    drop = true;
                }
            }
            if (!drop) continue;
            WantedPosterPackageEntity pkg = new WantedPosterPackageEntity(player.field_70170_p);
            pkg.func_70012_b(player.func_226277_ct_() + WyHelper.randomWithRange(-10, 10), player.func_226278_cu_() + 30.0, player.func_226281_cx_() + WyHelper.randomWithRange(-10, 10), 0.0f, 0.0f);
            player.field_70170_p.func_217376_c((Entity)pkg);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
    }

    @SubscribeEvent
    public static void onBountyKilled(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            if (!props.isBountyHunter()) {
                return;
            }
            LivingEntity target = event.getEntityLiving();
            ExtendedWorldData worldData = ExtendedWorldData.get();
            IEntityStats targetProps = EntityStatsCapability.get(target);
            StatChangeSource source = StatChangeSource.KILL_NPC;
            if (target instanceof PlayerEntity) {
                source = StatChangeSource.KILL_PLAYER;
            }
            WyNetwork.sendTo(new SSyncEntityStatsPacket(target.func_145782_y(), targetProps), player);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                boolean hasBounty;
                UUID uuid;
                CompoundNBT tag;
                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                if (!itemStack.func_77942_o() || (tag = itemStack.func_77978_p().func_74775_l("WPData")) == null || tag.isEmpty() || (uuid = tag.func_186857_a("UUID")) == null) continue;
                boolean isTarget = uuid.equals(target.func_110124_au());
                long bounty = worldData.getBounty(target.func_110124_au());
                boolean bl = hasBounty = bounty > 0L;
                if (!isTarget || !hasBounty) continue;
                worldData.issueBounty(uuid, 0L);
                targetProps.setBounty(0L);
                ItemsHelper.removeItemStackFromInventory((LivingEntity)player, itemStack);
                if (!props.alterBelly(bounty, source)) continue;
                WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
            }
        }
    }

    private static /* synthetic */ boolean lambda$dropWantedPosters$0(PlayerEntity player, PlayerEntity target) {
        return target == player;
    }
}

