/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.zoan;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.abilities.toriphoenix.PhoenixFlyPointAbility;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.models.morphs.ChickenPhoenixModel;
import xyz.pixelatedw.mineminenomi.models.morphs.PhoenixFlyModel;
import xyz.pixelatedw.mineminenomi.renderers.morphs.FlyPointRenderer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PhoenixFlyMorphInfo
extends MorphInfo {
    private static final EntitySize STANDING_SIZE = EntitySize.func_220314_b((float)1.2f, (float)1.2f);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IRenderFactory getRendererFactory() {
        if (WyHelper.isAprilFirst()) {
            return super.getRendererFactory();
        }
        return new FlyPointRenderer.Factory(this, true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MorphModel getModel() {
        if (WyHelper.isAprilFirst()) {
            return new ChickenPhoenixModel();
        }
        return new PhoenixFlyModel();
    }

    @Override
    @Nullable
    public ResourceLocation getTexture(LivingEntity entity) {
        if (WyHelper.isAprilFirst()) {
            return new ResourceLocation("mineminenomi", "textures/models/zoanmorph/phoenix_chicken.png");
        }
        return super.getTexture(entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void preRenderCallback(LivingEntity entity, MatrixStack matrixStack, float partialTickTime) {
        if (WyHelper.isAprilFirst()) {
            float scale = 1.8f;
            matrixStack.func_227862_a_(scale, scale, scale);
            matrixStack.func_227861_a_(0.0, (double)0.35f, 0.0);
            return;
        }
        float scale = 1.8f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_(0.0, 1.0, 0.0);
    }

    @Override
    public AkumaNoMiItem getDevilFruit() {
        return ModAbilities.TORI_TORI_NO_MI_PHOENIX;
    }

    @Override
    public String getForm() {
        return "phoenix_fly";
    }

    @Override
    public String getDisplayName() {
        return PhoenixFlyPointAbility.INSTANCE.getUnlocalizedName();
    }

    @Override
    public double getEyeHeight() {
        return 0.8;
    }

    @Override
    public float getShadowSize() {
        return 1.0f;
    }

    @Override
    public boolean canMount() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasEqualDepthTest() {
        return true;
    }

    @Override
    public Map<Pose, EntitySize> getSizes() {
        return ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_SIZE).build();
    }
}

