/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.zoan;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.abilities.saraaxolotl.AxolotlWalkPointAbility;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.models.morphs.AxolotlWalkModel;

public class AxolotlWalkMorphInfo
extends MorphInfo {
    private static final EntitySize STANDING_SIZE = EntitySize.func_220314_b((float)0.6f, (float)0.5f);
    private static final EntitySize CROUCHING_SIZE = EntitySize.func_220314_b((float)0.6f, (float)0.4f);
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_walk_0.png"), new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_walk_1.png"), new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_walk_2.png"), new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_walk_3.png"), new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_walk_4.png")};

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MorphModel getModel() {
        return new AxolotlWalkModel();
    }

    @Override
    @Nullable
    public ResourceLocation getTexture(LivingEntity entity) {
        String[] bits = ("" + entity.func_110124_au().getMostSignificantBits()).split("");
        int scheme = 0;
        for (String bit : bits) {
            if (bit.equalsIgnoreCase("-")) continue;
            scheme += Integer.parseInt(bit);
        }
        int len = 4;
        scheme = MathHelper.func_76125_a((int)(scheme & len), (int)0, (int)len);
        return TEXTURES[scheme];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void preRenderCallback(LivingEntity entity, MatrixStack matrixStack, float partialTickTime) {
    }

    @Override
    public AkumaNoMiItem getDevilFruit() {
        return ModAbilities.SARA_SARA_NO_MI_AXOLOTL;
    }

    @Override
    public String getForm() {
        return "axolotl_walk";
    }

    @Override
    public String getDisplayName() {
        return AxolotlWalkPointAbility.INSTANCE.getUnlocalizedName();
    }

    @Override
    public double getEyeHeight() {
        return 0.4;
    }

    @Override
    public float getShadowSize() {
        return 0.5f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasEqualDepthTest() {
        return true;
    }

    @Override
    public Map<Pose, EntitySize> getSizes() {
        return ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_SIZE).put((Object)Pose.CROUCHING, (Object)CROUCHING_SIZE).build();
    }
}

