/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.zoan;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.abilities.saraaxolotl.AxolotlHeavyPointAbility;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.models.morphs.AxolotlHeavyModel;

public class AxolotlHeavyMorphInfo
extends MorphInfo {
    private static final EntitySize STANDING_SIZE = EntitySize.func_220314_b((float)2.5f, (float)4.0f);
    private static final EntitySize CROUCHING_SIZE = EntitySize.func_220314_b((float)2.5f, (float)3.8f);
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_heavy_0.png"), new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_heavy_1.png"), new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_heavy_2.png"), new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_heavy_3.png"), new ResourceLocation("mineminenomi", "textures/models/zoanmorph/axolotl_heavy_4.png")};

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MorphModel getModel() {
        return new AxolotlHeavyModel();
    }

    @Override
    @Nullable
    public ResourceLocation getTexture(LivingEntity entity) {
        String[] bits = ("" + entity.func_110124_au().getMostSignificantBits()).split("");
        int scheme = 0;
        for (String bit : bits) {
            if (bit.equalsIgnoreCase("-")) continue;
            scheme += Integer.parseInt(bit);
        }
        int len = 4;
        scheme = MathHelper.func_76125_a((int)(scheme & len), (int)0, (int)len);
        return TEXTURES[scheme];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void preRenderCallback(LivingEntity entity, MatrixStack matrixStack, float partialTickTime) {
        float scale = 1.6f;
        matrixStack.func_227862_a_(scale, scale, scale);
    }

    @Override
    public AkumaNoMiItem getDevilFruit() {
        return ModAbilities.SARA_SARA_NO_MI_AXOLOTL;
    }

    @Override
    public String getForm() {
        return "axolotl_heavy";
    }

    @Override
    public String getDisplayName() {
        return AxolotlHeavyPointAbility.INSTANCE.getUnlocalizedName();
    }

    @Override
    public double getEyeHeight() {
        return 3.7;
    }

    @Override
    public float getShadowSize() {
        return 1.8f;
    }

    @Override
    public boolean canMount() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasEqualDepthTest() {
        return true;
    }

    @Override
    public Map<Pose, EntitySize> getSizes() {
        return ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_SIZE).put((Object)Pose.CROUCHING, (Object)CROUCHING_SIZE).build();
    }
}

