/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.yami;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yami.YamiProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DarkMatterProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE).build();

    public DarkMatterProjectile(EntityType type, World world) {
        super(type, world);
    }

    public DarkMatterProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)YamiProjectiles.DARK_MATTER.get(), world, player, ability.getCore());
        this.setDamage(15.0f);
        this.setMaxLife(20);
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.createFilledSphere(this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 3, (Block)ModBlocks.DARKNESS.get(), GRIEF_RULE);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DARK_MATTER.get(), (Entity)this, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p());
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
    }
}

