/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.suna;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertSpadaAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.SunaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DesertSpadaProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(CoreBlockProtectionRule.INSTANCE).build();
    private double initialY;

    public DesertSpadaProjectile(EntityType type, World world) {
        super(type, world);
    }

    public DesertSpadaProjectile(World world, LivingEntity player) {
        super((EntityType)SunaProjectiles.DESERT_SPADA.get(), world, player, DesertSpadaAbility.INSTANCE);
        this.setDamage(30.0f);
        this.setMaxLife(45);
        this.setPassThroughEntities();
        this.setPassThroughBlocks();
        this.withEffects = () -> new EffectInstance[]{new EffectInstance((Effect)ModEffects.DEHYDRATION.get(), 200, 1)};
        this.initialY = player.func_226278_cu_();
        this.setEntityCollisionSize(2.0);
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177979_c(j));
            if (state.func_185904_a().func_76220_a()) {
                pos = this.func_233580_cy_().func_177979_c(j);
                break;
            }
            if (j > 5) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        AbilityHelper.createFilledSphere(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 2, Blocks.field_150350_a, GRIEF_RULE);
        AbilityHelper.createFilledSphere(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p(), 2, Blocks.field_150350_a, GRIEF_RULE);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DESERT_SPADA.get(), (Entity)this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }
}

