/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.ope;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ope.OpeProjectiles;

public class TaktBlockEntity
extends Entity {
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamageAmount = 2.0f;
    public CompoundNBT blockData;
    protected static final DataParameter<BlockPos> DATA_START_POS = EntityDataManager.func_187226_a(TaktBlockEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    protected static final DataParameter<Optional<BlockState>> BLOCK_STATE = EntityDataManager.func_187226_a(TaktBlockEntity.class, (IDataSerializer)DataSerializers.field_187197_g);

    public TaktBlockEntity(EntityType type, World world) {
        super(type, world);
    }

    public TaktBlockEntity(World world, double x, double y, double z, BlockState state) {
        super((EntityType)OpeProjectiles.TAKT_BLOCK.get(), world);
        this.setBlockState(state);
        this.field_70156_m = true;
        this.func_70107_b(x, y + (double)((1.0f - this.func_213302_cg()) / 2.0f), z);
        AbilityHelper.setDeltaMovement(this, Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setStartPos(this.func_233580_cy_());
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setStartPos(BlockPos pStartPos) {
        this.field_70180_af.func_187227_b(DATA_START_POS, (Object)pStartPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getStartPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(DATA_START_POS);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_START_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(BLOCK_STATE, Optional.empty());
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        if (this.getBlockState().func_196958_f()) {
            this.func_70106_y();
        } else {
            Block block = this.getBlockState().func_177230_c();
            if (this.time++ == 0) {
                BlockPos blockpos = this.func_233580_cy_();
                if (this.field_70170_p.func_180495_p(blockpos).func_203425_a(block)) {
                    this.field_70170_p.func_217377_a(blockpos, false);
                } else if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
            if (!this.func_189652_ae()) {
                AbilityHelper.setDeltaMovement(this, this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (!this.field_70170_p.field_72995_K) {
                BlockRayTraceResult blockraytraceresult;
                BlockPos blockpos1 = this.func_233580_cy_();
                boolean flag = this.getBlockState().func_177230_c() instanceof ConcretePowderBlock;
                boolean flag1 = flag && this.field_70170_p.func_204610_c(blockpos1).func_206884_a((ITag)FluidTags.field_206959_a);
                double d0 = this.func_213322_ci().func_189985_c();
                if (flag && d0 > 1.0 && (blockraytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.field_70169_q, this.field_70167_r, this.field_70166_s), this.func_213303_ch(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)this))).func_216346_c() != RayTraceResult.Type.MISS && this.field_70170_p.func_204610_c(blockraytraceresult.func_216350_a()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    blockpos1 = blockraytraceresult.func_216350_a();
                    flag1 = true;
                }
                if (!this.func_233570_aj_() && !flag1) {
                    if (!(this.field_70170_p.field_72995_K || (this.time <= 100 || blockpos1.func_177956_o() >= 1 && blockpos1.func_177956_o() <= 256) && this.time <= 600)) {
                        if (this.dropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a((IItemProvider)block);
                        }
                        this.func_70106_y();
                    }
                } else {
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockpos1);
                    AbilityHelper.setDeltaMovement(this, this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
                    if (!blockstate.func_203425_a(Blocks.field_196603_bb)) {
                        this.func_70106_y();
                        if (!this.cancelDrop) {
                            boolean flag4;
                            boolean flag2 = blockstate.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, blockpos1, Direction.DOWN, ItemStack.field_190927_a, Direction.UP));
                            boolean flag3 = FallingBlock.func_185759_i((BlockState)this.field_70170_p.func_180495_p(blockpos1.func_177977_b())) && (!flag || !flag1);
                            boolean bl = flag4 = this.getBlockState().func_196955_c((IWorldReader)this.field_70170_p, blockpos1) && !flag3;
                            if (flag2 && flag4) {
                                if (this.getBlockState().func_235901_b_((Property)BlockStateProperties.field_208198_y) && this.field_70170_p.func_204610_c(blockpos1).func_206886_c() == Fluids.field_204546_a) {
                                    this.setBlockState((BlockState)this.getBlockState().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)));
                                }
                                if (this.field_70170_p.func_180501_a(blockpos1, this.getBlockState(), 3)) {
                                    ProtectedArea area;
                                    TileEntity tileentity;
                                    if (this.blockData != null && this.getBlockState().hasTileEntity() && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                                        CompoundNBT compoundnbt = tileentity.func_189515_b(new CompoundNBT());
                                        for (String s : this.blockData.func_150296_c()) {
                                            INBT inbt = this.blockData.func_74781_a(s);
                                            if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                            compoundnbt.func_218657_a(s, inbt.func_74737_b());
                                        }
                                        tileentity.func_230337_a_(this.getBlockState(), compoundnbt);
                                        tileentity.func_70296_d();
                                    }
                                    if ((area = ProtectedAreasData.get(this.field_70170_p).getProtectedArea(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p())) != null) {
                                        area.queueForRestoration(this.field_70170_p, blockpos1);
                                    }
                                } else if (this.dropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                    this.func_199703_a((IItemProvider)block);
                                }
                            } else if (this.dropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                this.func_199703_a((IItemProvider)block);
                            }
                        }
                    }
                }
            }
            AbilityHelper.setDeltaMovement(this, this.func_213322_ci().func_186678_a(0.98));
        }
    }

    public boolean func_225503_b_(float pFallDistance, float pDamageMultiplier) {
        int i;
        if (this.hurtEntities && (i = MathHelper.func_76123_f((float)(pFallDistance - 1.0f))) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            boolean flag = this.getBlockState().func_235714_a_((ITag)BlockTags.field_200572_k);
            DamageSource damagesource = flag ? DamageSource.field_82728_o : DamageSource.field_82729_p;
            for (Entity entity : list) {
                entity.func_70097_a(damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)i * this.fallDamageAmount)), this.fallDamageMax));
            }
            if (flag && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)i * 0.05) {
                BlockState blockstate = AnvilBlock.func_196433_f((BlockState)this.getBlockState());
                if (blockstate == null) {
                    this.cancelDrop = true;
                } else {
                    this.setBlockState(blockstate);
                }
            }
        }
        return false;
    }

    protected void func_213281_b(CompoundNBT pCompound) {
        pCompound.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.getBlockState()));
        pCompound.func_74768_a("Time", this.time);
        pCompound.func_74757_a("DropItem", this.dropItem);
        pCompound.func_74757_a("HurtEntities", this.hurtEntities);
        pCompound.func_74776_a("FallHurtAmount", this.fallDamageAmount);
        pCompound.func_74768_a("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            pCompound.func_218657_a("TileEntityData", (INBT)this.blockData);
        }
    }

    protected void func_70037_a(CompoundNBT pCompound) {
        this.setBlockState(NBTUtil.func_190008_d((CompoundNBT)pCompound.func_74775_l("BlockState")));
        this.time = pCompound.func_74762_e("Time");
        if (pCompound.func_150297_b("HurtEntities", 99)) {
            this.hurtEntities = pCompound.func_74767_n("HurtEntities");
            this.fallDamageAmount = pCompound.func_74760_g("FallHurtAmount");
            this.fallDamageMax = pCompound.func_74762_e("FallHurtMax");
        } else if (this.getBlockState().func_235714_a_((ITag)BlockTags.field_200572_k)) {
            this.hurtEntities = true;
        }
        if (pCompound.func_150297_b("DropItem", 99)) {
            this.dropItem = pCompound.func_74767_n("DropItem");
        }
        if (pCompound.func_150297_b("TileEntityData", 10)) {
            this.blockData = pCompound.func_74775_l("TileEntityData");
        }
        if (this.getBlockState().func_196958_f()) {
            this.setBlockState(Blocks.field_150354_m.func_176223_P());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public World getLevel() {
        return this.field_70170_p;
    }

    public void setHurtsEntities(boolean pHurtEntities) {
        this.hurtEntities = pHurtEntities;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void func_85029_a(CrashReportCategory pCategory) {
        super.func_85029_a(pCategory);
        pCategory.func_71507_a("Immitating BlockState", (Object)this.getBlockState().toString());
    }

    public boolean func_184213_bq() {
        return true;
    }

    public void setBlockState(BlockState state) {
        this.func_184212_Q().func_187227_b(BLOCK_STATE, Optional.of(state));
    }

    public BlockState getBlockState() {
        if (!((Optional)this.func_184212_Q().func_187225_a(BLOCK_STATE)).isPresent()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return (BlockState)((Optional)this.func_184212_Q().func_187225_a(BLOCK_STATE)).get();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

