/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.nikyu.PainRepelAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu.NikyuProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class PainEntity
extends AbilityProjectileEntity {
    public PainEntity(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public PainEntity(World world, LivingEntity player) {
        super((EntityType)NikyuProjectiles.PAIN.get(), world, player, PainRepelAbility.INSTANCE);
        super.setArmorPiercing(1.0f);
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        float size = Math.min(super.getDamage(), 20.0f);
        ExplosionAbility explosion = super.createExplosion((Entity)super.getThrower(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), Math.max(1.0f, size / 2.0f));
        explosion.setExplosionSound(true);
        explosion.setDamageEntities(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)size));
        explosion.doExplosion();
    }
}

