/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hie;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.HieProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class IceBlockPartisanProjectile
extends AbilityProjectileEntity {
    public IceBlockPartisanProjectile(EntityType type, World world) {
        super(type, world);
    }

    public IceBlockPartisanProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)HieProjectiles.ICE_BLOCK_PARTISAN.get(), world, player, ability);
        this.setDamage(9.0f);
        this.setMaxLife(40);
        super.setPhysical();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        AbilityHelper.addFrostbiteStacks(entity, super.getThrower(), 2);
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.placeBlockIfAllowed(this.getThrower(), hit, Blocks.field_205164_gk.func_176223_P(), DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                SimpleParticleData part = new SimpleParticleData((ParticleType)ModParticleTypes.HIE.get());
                part.setLife(32);
                part.setAnimationSpeed(5);
                part.setRotation(Vector3f.field_229183_f_);
                part.setRotationSpeed(i % 2 == 0 ? 0.07f : -0.07f);
                part.setSize(1.5f);
                WyHelper.spawnParticles(part, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

