/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hie;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.hie.IceBlockAvalancheAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.IFlexibleSizeProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.HieProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class IceBlockAvalancheProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(IceBlockAvalancheProjectile.class, (IDataSerializer)DataSerializers.field_187193_c);
    public boolean finalized = false;

    public IceBlockAvalancheProjectile(EntityType type, World world) {
        super(type, world);
    }

    public IceBlockAvalancheProjectile(World world, LivingEntity player) {
        super((EntityType)HieProjectiles.ICE_BLOCK_AVALANCHE.get(), world, player, IceBlockAvalancheAbility.INSTANCE);
        this.setDamage(50.0f);
        this.setMaxLife(150);
        this.setPassThroughEntities();
        this.setCanGetStuckInGround();
        super.setPhysical();
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onTickEvent() {
        float mult = this.getSize() / 6.0f;
        this.func_174826_a(this.func_174813_aQ().func_186662_g((double)mult));
        this.setEntityCollisionSize(mult);
        if (!this.finalized) {
            this.setSize(this.getSize() + 0.4f);
        }
        if (this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_185904_a().func_76220_a()) {
            AbilityHelper.setDeltaMovement((Entity)this, 0.0, 0.0, 0.0);
        }
    }

    public void onBlockImpactEvent(BlockPos pos) {
        if (!this.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.ICE_BLOCK_AVALANCHE.get(), (Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    @Override
    public void setSize(float size) {
        this.func_184212_Q().func_187227_b(SIZE, (Object)Float.valueOf(Math.min(size, 50.0f)));
    }

    @Override
    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }
}

