/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.gomu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class GomuGomuNoRocketProjectile
extends AbilityProjectileEntity {
    public GomuGomuNoRocketProjectile(EntityType type, World world) {
        super(type, world);
    }

    public GomuGomuNoRocketProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)GomuProjectiles.GOMU_GOMU_NO_ROCKET.get(), world, player, ability);
        super.setDamage(4.0f);
        super.setLife(24);
        super.setFist();
        super.setDamageSource(((AbilityDamageSource)((Object)this.getDamageSource())).setSourceElement(SourceElement.RUBBER));
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        if (this.getLife() >= this.getMaxLife()) {
            return;
        }
        LivingEntity entity = this.getThrower();
        if (entity != null) {
            entity.func_195063_d((Effect)ModEffects.REDUCED_FALL.get());
            BlockPos distance = hit.func_177973_b((Vector3i)entity.func_233580_cy_());
            AbilityHelper.setDeltaMovement((Entity)entity, (double)distance.func_177958_n() * 0.35, 0.3 + (double)distance.func_177956_o() * 0.35, (double)distance.func_177952_p() * 0.35);
        }
    }
}

