/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.goe;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.IFlexibleSizeProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goe.GoeProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class DragonsRoarProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(DragonsRoarProjectile.class, (IDataSerializer)DataSerializers.field_187193_c);

    public DragonsRoarProjectile(EntityType type, World world) {
        super(type, world);
    }

    public DragonsRoarProjectile(World world, LivingEntity player, float size, Ability ability) {
        super((EntityType)GoeProjectiles.DRAGONS_ROAR.get(), world, player, ability);
        this.setDamage(10.0f);
        this.setMaxLife(30);
        this.setPassThroughEntities();
        this.setArmorPiercing(1.0f);
        this.setUnavoidable();
        this.setSize(size);
        this.setEntityCollisionSize(size / 2.0f, 3.0, size / 2.0f);
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos pos) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getSize() / 2.0f);
        explosion.setHeightDifference(45);
        explosion.setStaticBlockResistance(1.35f);
        explosion.setProtectOwnerFromFalling(true);
        explosion.setExplosionSound(true);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)this.getSize()));
        explosion.setDamageSource(this.bypassingSource);
        explosion.setStaticDamage(0.0f);
        explosion.doExplosion();
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    @Override
    public void setSize(float size) {
        this.func_184212_Q().func_187227_b(SIZE, (Object)Float.valueOf(MathHelper.func_76131_a((float)size, (float)1.0f, (float)50.0f)));
    }

    @Override
    public float getSize() {
        return ((Float)this.func_184212_Q().func_187225_a(SIZE)).floatValue();
    }
}

