/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.extra;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.ExtraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ShockwaveParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShockwaveProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(CoreBlockProtectionRule.INSTANCE).build();
    private ShockwaveParticleEffect.Details particleDetails = new ShockwaveParticleEffect.Details(2);
    private boolean canBreakBlocks = false;
    private int size = 2;

    public ShockwaveProjectile(EntityType type, World world) {
        super(type, world);
    }

    public ShockwaveProjectile(World world, LivingEntity entity, AbilityCore<?> parent) {
        this(world, entity, parent, false);
    }

    public ShockwaveProjectile(World world, LivingEntity entity, AbilityCore<?> parent, boolean canBreakBlocks) {
        super((EntityType)ExtraProjectiles.SHOCKWAVE.get(), world, entity, parent);
        this.setDamage(8.0f);
        this.setSize(this.size);
        this.setMaxLife(20);
        this.setPassThroughEntities();
        this.onTickEvent = this::onTickEvent;
        this.canBreakBlocks = canBreakBlocks;
    }

    public void setSize(int size) {
        this.size = size;
        this.setEntityCollisionSize(size);
        this.particleDetails = new ShockwaveParticleEffect.Details(size);
    }

    public void setBreakBlocks(boolean flag) {
        this.canBreakBlocks = flag;
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177979_c(j));
            if (state.func_200132_m()) {
                pos = this.func_233580_cy_().func_177979_c(j);
                break;
            }
            if (j > 5) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        if (this.canBreakBlocks) {
            AbilityHelper.createSphere(this.field_70170_p, new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), this.size, false, Blocks.field_150350_a, 258, GRIEF_RULE);
        }
        if (this.field_70173_aa % 2 == 0) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.SHOCKWAVE.get(), (Entity)this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.particleDetails);
        }
    }
}

