/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.electro;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.electro.ElectricalLunaAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.electro.ElectroProjectiles;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ElectricalLunaProjectile
extends AbilityProjectileEntity {
    private ElectricalLunaAbility ability;

    public ElectricalLunaProjectile(EntityType type, World world) {
        super(type, world);
    }

    public ElectricalLunaProjectile(World world, LivingEntity player, ElectricalLunaAbility ability) {
        super((EntityType)ElectroProjectiles.ELECTRICAL_LUNA.get(), world, player, ability);
        this.ability = ability;
        this.setMaxLife(20);
        this.setPassThroughEntities();
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onHitBlock;
    }

    private void onHitBlock(BlockPos pos) {
        this.ability.getComponent(ModAbilityKeys.RANGE).ifPresent(comp -> {
            int range = 6;
            List<LivingEntity> targets = comp.getTargetsInArea(this.getThrower(), range);
            for (LivingEntity target : targets) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 30, 0));
                int amount = 16;
                for (int j = 0; j < amount; ++j) {
                    float boltSize = (float)WyHelper.randomWithRange(3, range);
                    LightningEntity bolt = new LightningEntity((Entity)this, target.func_233580_cy_().func_177958_n(), (double)target.func_233580_cy_().func_177956_o() + 0.25, target.func_233580_cy_().func_177952_p(), (float)WyHelper.randomWithRange(0, 360), (float)WyHelper.randomWithRange(0, 5), boltSize, 8.0f, this.ability.getCore());
                    bolt.setAngle(60);
                    bolt.setMaxLife(20);
                    bolt.setDamage(0.0f);
                    bolt.setExplosion(0, false);
                    bolt.setSize(boltSize / 600.0f);
                    bolt.setBranches((int)WyHelper.randomWithRange(1, 3));
                    bolt.setSegments((int)((double)boltSize * 0.6));
                    bolt.setLightningMimic(false);
                    this.field_70170_p.func_217376_c((Entity)bolt);
                }
            }
        });
    }

    private void onTickEvent() {
        if (this.field_70173_aa < 0) {
            return;
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.ELECTRICAL_LUNA.get(), (Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }
}

