/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.doru;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.doru.CandleChampionAbility;
import xyz.pixelatedw.mineminenomi.abilities.doru.CandleLockAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doru.DoruProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CandleLockProjectile
extends AbilityProjectileEntity {
    public CandleLockProjectile(EntityType type, World world) {
        super(type, world);
    }

    public CandleLockProjectile(World world, LivingEntity player, CandleLockAbility ability) {
        super((EntityType)DoruProjectiles.CANDLE_LOCK.get(), world, player, ability);
        this.setDamage(8.0f);
        this.setMaxLife(20);
        this.setPassThroughEntities();
        super.setPhysical();
        this.setEntityCollisionSize(3.0);
        this.withEffects = this::withEffects;
        Ability candleChampion = AbilityDataCapability.get(this.getThrower()).getEquippedAbility(CandleChampionAbility.INSTANCE);
        if (candleChampion != null && candleChampion.isContinuous()) {
            this.setEntityCollisionSize(5.0, 3.0, 5.0);
        }
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177979_c(j));
            if (state.func_185904_a().func_76220_a()) {
                pos = this.func_233580_cy_().func_177979_c(j);
                break;
            }
            if (j > 5) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CANDLE_LOCK.get(), (Entity)this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private EffectInstance[] withEffects() {
        if (this.getThrower() == null) {
            this.func_70106_y();
        }
        int time = 200;
        int modifier = 1;
        if (this.getThrower() instanceof PlayerEntity) {
            Ability ability;
            if (((PlayerEntity)this.getThrower()).field_71071_by.func_213902_a((Set)ImmutableSet.of((Object)ModItems.COLOR_PALETTE.get()))) {
                modifier = 2;
            }
            if ((ability = (Ability)AbilityDataCapability.get(this.getThrower()).getEquippedAbility(CandleChampionAbility.INSTANCE)) != null && ability.isContinuous()) {
                time = 300;
            }
        }
        return new EffectInstance[]{new EffectInstance((Effect)ModEffects.CANDLE_LOCK.get(), time, modifier)};
    }
}

