/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.worldgov;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.EventsWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DespawnAfterTimeGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.RandomWalkingAroundHomeGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.RunTowardsLocationGoal;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.mixins.IGoalSelectorMixin;

public class CelestialDragonEntity
extends OPEntity {
    private static final byte MOUNT_EVENT = 100;
    private static final byte UNMOUNT_EVENT = 101;
    private Color hairColor = Color.BLACK;
    private boolean ridingSlave = true;
    private boolean secondChance = false;
    private boolean gotHitOnce = false;

    public CelestialDragonEntity(EntityType type, World world) {
        super(type, world, MobsHelper.CELESTIAL_DRAGONS_TEXTURES);
    }

    public void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, new RandomWalkingAroundHomeGoal<CelestialDragonEntity>(this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, VillagerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
        props.setFaction(ModValues.MARINE);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 0.1).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233826_i_, 1.0);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        Color color;
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        float r = this.func_70681_au().nextFloat();
        float g = this.func_70681_au().nextFloat();
        float b = this.func_70681_au().nextFloat();
        this.hairColor = color = new Color(r, g, b);
        ItemStack bubbleStack = ((Item)ModArmors.CELESTIAL_DRAGON_BUBBLE.get()).func_190903_i();
        bubbleStack.func_190925_c("display").func_74768_a("color", this.hairColor.getRGB());
        this.func_184201_a(EquipmentSlotType.HEAD, bubbleStack);
        this.mountSlave();
        return spawnData;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            Entity attacker = source.func_76364_f();
            if (attacker != null && attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                IEntityStats props = EntityStatsCapability.get(livingAttacker);
                if (!this.gotHitOnce) {
                    props.alterBounty(10000L, StatChangeSource.KILL_NPC);
                    this.gotHitOnce = true;
                    if (props.isMarine() || props.isBountyHunter()) {
                        props.alterLoyalty(-100.0, StatChangeSource.KILL_NPC);
                    }
                    if (EntityPredicates.field_188444_d.test(livingAttacker)) {
                        EventsWorldData.get().addSpecialBusterCall((ServerWorld)this.field_70170_p, livingAttacker);
                    }
                }
                if (!this.secondChance && this.func_110143_aJ() - amount <= 0.0f) {
                    this.func_70606_j(1.0f);
                    this.field_70725_aQ = 0;
                    this.secondChance = true;
                }
                double knockbackDistance = 0.5;
                double knockbackHeight = 0.0;
                if (HakiHelper.hasHardeningActive(livingAttacker, false, false)) {
                    knockbackDistance += 0.2;
                }
                if (HakiHelper.hasAdvancedBusoActive(livingAttacker)) {
                    knockbackDistance += 1.0;
                }
                if (HakiHelper.hasInfusionActive(livingAttacker)) {
                    knockbackDistance += 1.0;
                }
                if (knockbackDistance > 1.0) {
                    knockbackHeight = 0.5;
                    this.unmountSlave(livingAttacker);
                    livingAttacker.func_195064_c(new EffectInstance((Effect)ModEffects.IMPACT_FRAME.get(), 2, 0));
                }
                Vector3d push = livingAttacker.func_70040_Z().func_72441_c(0.0, knockbackHeight, 0.0).func_216372_d(knockbackDistance, 1.0, knockbackDistance);
                AbilityHelper.setDeltaMovement((Entity)this, push);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 100: {
                this.ridingSlave = true;
                break;
            }
            case 101: {
                this.field_70725_aQ = 0;
                this.ridingSlave = false;
            }
        }
        super.func_70103_a(id);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("hitOnce", this.gotHitOnce);
        nbt.func_74757_a("ridingSlave", this.ridingSlave);
        nbt.func_74768_a("hairColor", this.hairColor.getRGB());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.gotHitOnce = nbt.func_74767_n("hitOnce");
        this.ridingSlave = nbt.func_74767_n("ridingSlave");
        this.hairColor = new Color(nbt.func_74762_e("hairColor"));
    }

    @Override
    public void writeSpawnData(PacketBuffer buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.hairColor.getRGB());
    }

    @Override
    public void readSpawnData(PacketBuffer buffer) {
        super.readSpawnData(buffer);
        this.hairColor = new Color(buffer.readInt());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        if (!this.ridingSlave) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)101);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        LivingEntity attacker = this.func_94060_bK();
        if (attacker != null && attacker.func_70089_S() && this.ridingSlave) {
            this.unmountSlave(attacker);
        }
    }

    public void mountSlave() {
        this.ridingSlave = true;
        this.field_70170_p.func_72960_a((Entity)this, (byte)100);
    }

    public void unmountSlave(LivingEntity attacker) {
        if (!this.ridingSlave) {
            return;
        }
        this.ridingSlave = false;
        this.field_70170_p.func_72960_a((Entity)this, (byte)101);
        this.spawnFreedSlave(attacker);
    }

    private void spawnFreedSlave(LivingEntity attacker) {
        VillagerEntity slave = new VillagerEntity(EntityType.field_200756_av, this.field_70170_p);
        slave.func_233576_c_(this.func_213303_ch());
        IGoalSelectorMixin goalSelector = (IGoalSelectorMixin)slave.field_70714_bg;
        goalSelector.getAvailableGoals().clear();
        int xOffset = 50 + this.field_70146_Z.nextInt(50);
        if (this.field_70146_Z.nextBoolean()) {
            xOffset *= -1;
        }
        int zOffset = 50 + this.field_70146_Z.nextInt(50);
        if (this.field_70146_Z.nextBoolean()) {
            zOffset *= -1;
        }
        Vector3d runLocation = this.func_213303_ch().func_72441_c((double)xOffset, 0.0, (double)zOffset);
        slave.field_70714_bg.func_75776_a(0, new RunTowardsLocationGoal<VillagerEntity>(slave, 1.5, runLocation));
        slave.field_70714_bg.func_75776_a(0, (Goal)new DespawnAfterTimeGoal((MobEntity)slave, 40));
        this.field_70170_p.func_217376_c((Entity)slave);
        IEntityStats props = EntityStatsCapability.get(attacker);
        props.addFreedSlaves(1);
        if (props.isRevolutionary()) {
            props.alterLoyalty(0.5, StatChangeSource.KILL_NPC);
        }
    }

    public boolean isRidingSlave() {
        return this.ridingSlave;
    }

    public Color getHairColor() {
        return this.hairColor;
    }
}

