/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.entities.TrainerEntity;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.IHakiTrainer;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ArtOfWeatherTrainerEntity
extends TrainerEntity
implements IHakiTrainer {
    public ArtOfWeatherTrainerEntity(EntityType type, World world) {
        super(type, world, MobsHelper.WEATHER_TRAINER_TEXTURES);
        EntityStatsCapability.get((LivingEntity)this).setFightingStyle(ModValues.ART_OF_WEATHER);
    }

    @Override
    public void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, (double)0.22f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_((Attribute)ModAttributes.TOUGHNESS.get(), 12.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        if (this.field_70146_Z.nextDouble() < 0.4) {
            ItemStack climaTact = new ItemStack((IItemProvider)ModWeapons.CLIMA_TACT.get());
            this.func_184201_a(EquipmentSlotType.MAINHAND, climaTact);
        }
        this.setDoriki(1000.0 + WyHelper.randomWithRange(0, 1000));
        this.setBelly(20.0 + WyHelper.randomWithRange(0, 10));
        return spawnData;
    }

    @Override
    public List<QuestId> getAvailableQuests(PlayerEntity player) {
        IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
        ArrayList<QuestId> availableQuests = new ArrayList<QuestId>();
        if (entityProps.isWeatherWizard()) {
            availableQuests.addAll(ModQuests.ART_OF_WEATHER_TRIALS.stream().map(reg -> reg).collect(Collectors.toList()));
        }
        return availableQuests;
    }

    @Override
    public HakiType getTrainingHaki() {
        return HakiType.KENBUNSHOKU;
    }
}

