/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks;

import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.potion.Effect;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.doru.CandleChampionAbility;
import xyz.pixelatedw.mineminenomi.abilities.doru.CandleLockAbility;
import xyz.pixelatedw.mineminenomi.abilities.doru.DoruDoruArtsMoriAbility;
import xyz.pixelatedw.mineminenomi.abilities.doru.DoruDoruNoYakataAbility;
import xyz.pixelatedw.mineminenomi.abilities.doru.TokudaiCandleAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ClimbOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.RunAwayFromTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.TauntTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.CandleChampionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.CandleLockWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.CandleWallWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.DoruDoruArtsKenWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.DoruDoruArtsMoriWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.DoruDoruBallWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.DoruDoruNoYakataWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru.TokudaiCandleWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.KamieWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.ShiganWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.mr3.Mr3PhaseSwitcherGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;

public class Mr3Entity
extends OPBossEntity<Mr3Entity> {
    private static final UUID TOKUDAI_YAKATA_COOLDOWN_BONUS = UUID.fromString("26687dbb-506c-4531-996c-ee35db1a2bb3");
    private static final UUID DORU_ARTS_MORI_COOLDOWN_BONUS = UUID.fromString("9b7ff21e-639a-4f1a-9919-6748fc9cf8b2");
    private static final UUID CHAMPION_FAUX_PROT_BONUS = UUID.fromString("6f0e2075-2051-4a3d-8854-0ea55e29b4e9");
    private static final UUID CHAMPION_TOUGHNESS_BONUS = UUID.fromString("ba4237ab-4e77-4ccb-85bd-71a81d248d45");
    private boolean hasColorPaletteBonus;
    private NPCPhase<Mr3Entity> standardPhase;
    private NPCPhase<Mr3Entity> championPhase;
    private NPCPhase<Mr3Entity> tokudaiPhase;
    private NPCPhase<Mr3Entity> tauntPhase;
    private DoruDoruNoYakataWrapperGoal doruYakataWrapper;
    private TokudaiCandleWrapperGoal tokudaiCandleWrapper;
    private CandleChampionWrapperGoal candleChampionWrapper;
    private DoruDoruArtsMoriWrapperGoal doruDoruArtsMoriWrapper;

    public Mr3Entity(EntityType type, World world) {
        super(type, world);
    }

    public Mr3Entity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.MR3.get(), challenge);
    }

    @Override
    public void initStats() {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.HUMAN);
        this.devilFruitData.setDevilFruit(ModAbilities.DORU_DORU_NO_MI);
        worldData.addTemporaryCrewMember(ModNPCGroups.BAROQUE_WORKS, (LivingEntity)this);
        this.entityStats.setDoriki(2000.0);
        this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
        this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(5.0);
        this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(1.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        if (this.isDifficultyHardOrAbove()) {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(5.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(5.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(6.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(400.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(12.0);
        }
    }

    @Override
    public void initGoals() {
        this.standardPhase = new SimplePhase<Mr3Entity>("Standard Phase", this);
        this.championPhase = new SimplePhase<Mr3Entity>("Champion Phase", this, this::onStartChampionPhaseEvent, this::onStopChampionPhaseEvent);
        this.tokudaiPhase = new SimplePhase<Mr3Entity>("Tokudai Phase", this, this::onStartTokudaiPhaseEvent, this::onStopTokudaiPhaseEvent);
        this.tauntPhase = new SimplePhase<Mr3Entity>("Taunt Phase", this, this::onStartTauntPhaseEvent, this::onStopTauntPhaseEvent);
        this.doruYakataWrapper = new DoruDoruNoYakataWrapperGoal((MobEntity)this);
        this.tokudaiCandleWrapper = new TokudaiCandleWrapperGoal((MobEntity)this);
        ((TokudaiCandleAbility)this.tokudaiCandleWrapper.getAbility()).setBlocksPerTick(100);
        this.candleChampionWrapper = new CandleChampionWrapperGoal((MobEntity)this);
        this.doruDoruArtsMoriWrapper = new DoruDoruArtsMoriWrapperGoal((MobEntity)this);
        DoruDoruBallWrapperGoal doruBallWrapper = new DoruDoruBallWrapperGoal((MobEntity)this);
        CandleLockWrapperGoal candleLockWrapper = new CandleLockWrapperGoal((MobEntity)this);
        ((CandleLockAbility)candleLockWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 60.0f));
        MobsHelper.addBasicNPCGoals(this);
        this.field_70714_bg.func_75776_a(0, (Goal)new Mr3PhaseSwitcherGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new ClimbOutOfHoleGoal((MobEntity)this));
        this.standardPhase.addGoal(1, new DashDodgeTargetGoal((MobEntity)this, 100.0f, 3.0f));
        this.standardPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.standardPhase.addGoal(2, new CandleWallWrapperGoal((MobEntity)this));
        this.standardPhase.addGoal(2, doruBallWrapper);
        this.standardPhase.addGoal(3, new DoruDoruArtsKenWrapperGoal((MobEntity)this));
        this.standardPhase.addGoal(3, this.doruDoruArtsMoriWrapper);
        this.standardPhase.addGoal(3, candleLockWrapper);
        this.standardPhase.addGoal(3, this.doruYakataWrapper);
        this.championPhase.addGoal(0, new SprintTowardsTargetGoal((MobEntity)this));
        this.championPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.1f, true));
        this.championPhase.addGoal(3, this.candleChampionWrapper);
        this.championPhase.addGoal(4, new CandleLockWrapperGoal((MobEntity)this));
        this.championPhase.addGoal(4, new DoruDoruArtsMoriWrapperGoal((MobEntity)this));
        this.tokudaiPhase.addGoal(0, new RunAwayFromTargetGoal<Mr3Entity>(this, 1.7, 500, 250));
        this.tokudaiPhase.addGoal(3, this.doruYakataWrapper);
        this.tokudaiPhase.addGoal(4, this.tokudaiCandleWrapper);
        this.getPhaseManager().setPhase(this.standardPhase);
        if (this.isDifficultyStandard()) {
            this.standardPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 200.0f, 3.0f));
            this.tokudaiPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 100.0f, 3.0f));
        } else {
            doruBallWrapper.setMinTriggerHits(3);
            ((TokudaiCandleAbility)this.tokudaiCandleWrapper.getAbility()).setBlocksPerTick(200);
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.standardPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 100.0f, 3.0f));
            this.standardPhase.addGoal(3, new ShiganWrapperGoal((MobEntity)this));
            this.tauntPhase.addGoal(0, new TauntTargetGoal((MobEntity)this));
            this.tauntPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true).setMoveTowardsTarget(false));
            this.tauntPhase.addGoal(1, new DashDodgeTargetGoal((MobEntity)this, 60.0f, 4.5f));
            this.tauntPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 20.0f, 4.5f));
            this.tauntPhase.addGoal(3, new KamieWrapperGoal((MobEntity)this));
            this.tauntPhase.addGoal(3, this.doruDoruArtsMoriWrapper);
            this.championPhase.addGoal(3, new HakaiHoWrapperGoal((MobEntity)this));
            this.tokudaiPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 80.0f, 4.0f));
            this.tokudaiPhase.addGoal(3, new KamieWrapperGoal((MobEntity)this));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.isDifficultyHardOrAbove()) {
            if (this.standardPhase.isActive(this) && this.func_70638_az().func_70644_a((Effect)ModEffects.CANDLE_LOCK.get()) && GoalUtil.hasHealthAbovePercentage((LivingEntity)this, 70.0)) {
                this.getPhaseManager().setPhase(this.tauntPhase);
            } else if (this.tauntPhase.isActive(this) && !this.func_70638_az().func_70644_a((Effect)ModEffects.CANDLE_LOCK.get())) {
                this.getPhaseManager().setPhase(this.standardPhase);
            }
        }
    }

    public boolean hasColorPaletteBonus() {
        return this.hasColorPaletteBonus;
    }

    public boolean isStandardPhase() {
        return this.standardPhase.isActive(this);
    }

    public boolean isChampionPhase() {
        return this.championPhase.isActive(this);
    }

    public boolean isTokudaiPhase() {
        return this.tokudaiPhase.isActive(this);
    }

    public void startStandardPhase() {
        this.getPhaseManager().setPhase(this.standardPhase);
    }

    public void startChampionPhase() {
        this.getPhaseManager().setPhase(this.championPhase);
    }

    public void startTokudaiPhase() {
        this.getPhaseManager().setPhase(this.tokudaiPhase);
    }

    public void onStartChampionPhaseEvent(Mr3Entity entity) {
        this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_233767_b_(new AttributeModifier(CHAMPION_FAUX_PROT_BONUS, "Faux Prot Bonus", 4.0, AttributeModifier.Operation.ADDITION));
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_233767_b_(new AttributeModifier(CHAMPION_TOUGHNESS_BONUS, "Toughness Bonus", 4.0, AttributeModifier.Operation.ADDITION));
        ((DoruDoruArtsMoriAbility)this.doruDoruArtsMoriWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.stopCooldown((LivingEntity)entity));
    }

    public void onStopChampionPhaseEvent(Mr3Entity entity) {
        this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_188479_b(CHAMPION_FAUX_PROT_BONUS);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_188479_b(CHAMPION_TOUGHNESS_BONUS);
    }

    public void onStartTokudaiPhaseEvent(Mr3Entity entity) {
        ((DoruDoruNoYakataAbility)this.doruYakataWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.stopCooldown((LivingEntity)entity));
        ((DoruDoruNoYakataAbility)this.doruYakataWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(TOKUDAI_YAKATA_COOLDOWN_BONUS, "Tokudai Phase Doru Yakata Cooldown Bonus", BonusOperation.ADD, -400.0f));
    }

    public void onStopTokudaiPhaseEvent(Mr3Entity entity) {
        ((DoruDoruNoYakataAbility)this.doruYakataWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().removeBonus(TOKUDAI_YAKATA_COOLDOWN_BONUS));
    }

    public void onStartTauntPhaseEvent(Mr3Entity entity) {
        ((DoruDoruArtsMoriAbility)this.doruDoruArtsMoriWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> {
            comp.getBonusManager().addBonus(DORU_ARTS_MORI_COOLDOWN_BONUS, "Taunt Doru Arts Mori Cooldown Bonus", BonusOperation.MUL, 0.5f);
            comp.stopCooldown((LivingEntity)entity);
        });
    }

    public void onStopTauntPhaseEvent(Mr3Entity entity) {
        ((DoruDoruArtsMoriAbility)this.doruDoruArtsMoriWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().removeBonus(DORU_ARTS_MORI_COOLDOWN_BONUS));
    }

    public boolean isChampionOnCooldown() {
        return ((CandleChampionAbility)this.candleChampionWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).get().isOnCooldown();
    }

    public boolean isTokudaiOnCooldown() {
        return ((TokudaiCandleAbility)this.tokudaiCandleWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).get().isOnCooldown();
    }
}

