/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks;

import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.HookGrabAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.HakaiHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.KamieAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertEncierroAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertGrandeEspadaAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertSpadaAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.GroundSeccoAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.SablesGuardAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.SablesPesadoAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaLogiaAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalDamageDealtRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalHitRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.TargetFlyStallingRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.TargetRunningAwayRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.HookGrabWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.KenbunshokuHakiFutureSightWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.KamieWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.BarjanWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.DesertEncierroWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.DesertGrandeEspadaWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.DesertSpadaWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.GroundSeccoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.SablesGuardWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.suna.SablesPesadoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.mr0.Mr0PhaseSwitcherGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.ModSwordItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class Mr0Entity
extends OPBossEntity<Mr0Entity> {
    private static final UUID HARD_GRANDE_SPADA_COOLDOWN_BONUS = UUID.fromString("5f6e5fd9-7292-42f0-895c-f0b3ff8da686");
    private static final UUID HARD_SABLES_GUARD_COOLDOWN_BONUS = UUID.fromString("c467addb-27c4-4865-9a01-655c621690e8");
    private static final UUID HARD_SABLES_PESADO_CHARGE_BONUS = UUID.fromString("8f324bfd-f8cd-434d-9467-3001fe7c92df");
    private static final AttributeModifier GCD_MOD = new AttributeModifier(UUID.fromString("e478aceb-9865-40da-a137-6359ba503bf0"), "GCD Modifier", -5.0, AttributeModifier.Operation.ADDITION);
    private static final int STANDARD_PAIN_THRESHOLD = 100;
    private static final int HARD_PAIN_THRESHOLD = 150;
    private static final int PAIN_GUARD_COOLDOWN = 200;
    private static final int KITING_THRESHOLD = 20;
    private final NPCPhase<Mr0Entity> firstPhase = new SimplePhase<Mr0Entity>("First Phase", this);
    private final NPCPhase<Mr0Entity> secondPhase = new SimplePhase<Mr0Entity>("Second Phase", this, this::startSecondPhaseEvent);
    private final NPCPhase<Mr0Entity> thirdPhase = new SimplePhase<Mr0Entity>("Third Phase", this, this::startThirdPhaseEvent);
    private final RevengeMeter painMeter = new RevengeMeter((LivingEntity)this, 999, 0);
    private final RevengeMeter kitingMeter = new RevengeMeter((LivingEntity)this, 100, 1);
    private HookGrabWrapperGoal hookGrabWrapper;
    private SablesGuardWrapperGoal sablesGuardWrapper;
    private GroundSeccoAbility groundSeccoAbility;
    private int painThreshold = 100;

    public Mr0Entity(EntityType type, World world) {
        super(type, world);
    }

    public Mr0Entity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.MR0.get(), challenge);
    }

    @Override
    public void initBoss() {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.HUMAN);
        this.devilFruitData.setDevilFruit(ModAbilities.SUNA_SUNA_NO_MI);
        worldData.addTemporaryCrewMember(ModNPCGroups.BAROQUE_WORKS, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        ItemStack capeStack = new ItemStack((IItemProvider)ModArmors.FLUFFY_CAPE.get());
        capeStack.func_190925_c("display").func_74768_a("color", WyHelper.hexToRGB("#1F2121").getRGB());
        this.func_184201_a(EquipmentSlotType.CHEST, capeStack);
        this.func_184201_a(EquipmentSlotType.OFFHAND, ((ModSwordItem)ModWeapons.HOOK.get()).func_190903_i());
        this.func_184201_a(EquipmentSlotType.HEAD, ((Item)ModItems.CIGAR.get()).func_190903_i());
        this.painMeter.addCheck(new PhysicalHitRevengeCheck(1));
        this.painMeter.addCheck(new PhysicalDamageDealtRevengeCheck());
        MobsHelper.addBasicNPCGoals(this);
        BarjanWrapperGoal barjanWrapper = new BarjanWrapperGoal((MobEntity)this);
        DesertEncierroWrapperGoal desertEncierroWrapper = new DesertEncierroWrapperGoal((MobEntity)this);
        ((DesertEncierroAbility)desertEncierroWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            if (((SablesGuardAbility)this.sablesGuardWrapper.getAbility()).isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            if (GoalUtil.hasEnoughTargetsAround((MobEntity)this, 2, 20.0f)) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        DesertGrandeEspadaWrapperGoal desertGrandeEspadaWrapper = new DesertGrandeEspadaWrapperGoal((MobEntity)this);
        ((DesertGrandeEspadaAbility)desertGrandeEspadaWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 400.0f));
        this.hookGrabWrapper = new HookGrabWrapperGoal((MobEntity)this);
        GroundSeccoWrapperGoal groundSeccoWrapper = new GroundSeccoWrapperGoal((MobEntity)this);
        this.groundSeccoAbility = (GroundSeccoAbility)groundSeccoWrapper.getAbility();
        this.groundSeccoAbility.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 600.0f));
        this.groundSeccoAbility.addCanUseCheck((entity, ability) -> {
            if (((SablesGuardAbility)this.sablesGuardWrapper.getAbility()).isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            if (((HookGrabAbility)this.hookGrabWrapper.getAbility()).isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        SablesPesadoWrapperGoal sablesPesadoWrapper = new SablesPesadoWrapperGoal((MobEntity)this);
        DesertSpadaWrapperGoal desertSpadaWrapper = new DesertSpadaWrapperGoal((MobEntity)this);
        ((DesertSpadaAbility)desertSpadaWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 200.0f));
        this.sablesGuardWrapper = new SablesGuardWrapperGoal((MobEntity)this);
        ((SablesGuardAbility)this.sablesGuardWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            if (((DesertEncierroAbility)desertEncierroWrapper.getAbility()).isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        ImprovedMeleeAttackGoal meleeAttackGoal = new ImprovedMeleeAttackGoal(this, 1.0, true);
        meleeAttackGoal.setEarlyStop(() -> ((GroundSeccoAbility)groundSeccoWrapper.getAbility()).isCharging() || ((SablesGuardAbility)this.sablesGuardWrapper.getAbility()).isContinuous() || ((SablesPesadoAbility)sablesPesadoWrapper.getAbility()).isCharging() || ((DesertEncierroAbility)desertEncierroWrapper.getAbility()).isCharging() || ((HookGrabAbility)this.hookGrabWrapper.getAbility()).isContinuous());
        this.field_70714_bg.func_75776_a(0, (Goal)new Mr0PhaseSwitcherGoal(this));
        this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<SunaLogiaAbility>((MobEntity)this, SunaLogiaAbility.INSTANCE));
        this.field_70714_bg.func_75776_a(0, (Goal)this.hookGrabWrapper);
        this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
        this.firstPhase.addGoal(1, (Goal)meleeAttackGoal);
        this.firstPhase.addGoal(3, barjanWrapper);
        this.firstPhase.addGoal(3, this.sablesGuardWrapper);
        this.secondPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 300.0f, 2.0f));
        this.secondPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 300.0f, 2.0f));
        this.secondPhase.addGoal(1, (Goal)meleeAttackGoal);
        this.secondPhase.addGoal(3, barjanWrapper);
        this.secondPhase.addGoal(3, this.sablesGuardWrapper);
        this.secondPhase.addGoal(3, desertEncierroWrapper);
        this.secondPhase.addGoal(3, groundSeccoWrapper);
        this.secondPhase.addGoal(3, desertGrandeEspadaWrapper);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
            this.getPhaseManager().setPhase(this.firstPhase);
            ((HookGrabAbility)this.hookGrabWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 400.0f));
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(6.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(400.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
            this.painThreshold = 150;
            this.kitingMeter.addCheck(new TargetFlyStallingRevengeCheck(1));
            this.kitingMeter.addCheck(new TargetRunningAwayRevengeCheck(1, 10.0f));
            HakaiHoWrapperGoal hakaiHoWrapper = new HakaiHoWrapperGoal((MobEntity)this);
            ((HakaiHoAbility)hakaiHoWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
                DesertEncierroAbility abl = AbilityDataCapability.get(entity).getEquippedAbility(DesertEncierroAbility.INSTANCE);
                if (abl != null && abl.isContinuous()) {
                    return AbilityUseResult.fail(null);
                }
                return AbilityUseResult.success();
            });
            ((HakaiHoAbility)hakaiHoWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 200.0f));
            KamieWrapperGoal kamieWrapper = new KamieWrapperGoal((MobEntity)this);
            ((KamieAbility)kamieWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
                float cooldown;
                if (this.groundSeccoAbility.isOnCooldown() && (cooldown = this.groundSeccoAbility.getComponent(ModAbilityKeys.COOLDOWN).map(comp -> Float.valueOf(comp.getCooldown())).orElse(Float.valueOf(0.0f)).floatValue()) <= 100.0f) {
                    return AbilityUseResult.fail(null);
                }
                return AbilityUseResult.success();
            });
            ((SablesPesadoAbility)sablesPesadoWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_SABLES_PESADO_CHARGE_BONUS, "Hard Sables Pesado Charge Bonus", BonusOperation.ADD, -40.0f));
            ((DesertGrandeEspadaAbility)desertGrandeEspadaWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_GRANDE_SPADA_COOLDOWN_BONUS, "Hard Grande Spada Cooldown Bonus", BonusOperation.ADD, -100.0f));
            this.groundSeccoAbility.setSizeModifier(1.5f);
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.secondPhase.addGoal(0, new KenbunshokuHakiFutureSightWrapperGoal((MobEntity)this));
            this.secondPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 250.0f, 2.5f));
            this.secondPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 250.0f, 2.5f));
            this.secondPhase.addGoal(0, kamieWrapper);
            this.secondPhase.addGoal(3, hakaiHoWrapper);
            this.thirdPhase.addGoal(0, new KenbunshokuHakiFutureSightWrapperGoal((MobEntity)this));
            this.thirdPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 250.0f, 2.5f));
            this.thirdPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 250.0f, 2.5f));
            this.thirdPhase.addGoal(0, kamieWrapper);
            this.thirdPhase.addGoal(1, (Goal)meleeAttackGoal);
            this.thirdPhase.addGoal(3, hakaiHoWrapper);
            this.thirdPhase.addGoal(3, barjanWrapper);
            this.thirdPhase.addGoal(3, this.sablesGuardWrapper);
            this.thirdPhase.addGoal(3, desertEncierroWrapper);
            this.thirdPhase.addGoal(3, groundSeccoWrapper);
            this.thirdPhase.addGoal(3, sablesPesadoWrapper);
            this.thirdPhase.addGoal(3, desertGrandeEspadaWrapper);
            this.getPhaseManager().setPhase(this.secondPhase);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.28f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233820_c_, 0.2);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.painMeter.tick();
            this.kitingMeter.tick();
            if (!((SablesGuardAbility)this.sablesGuardWrapper.getAbility()).isContinuous() && this.painMeter.getRevengeValue() > this.painThreshold && this.sablesGuardWrapper.hasTimePassedSinceLastEnd(200.0f)) {
                this.painMeter.addRevengeValue(-this.painThreshold);
                ((SablesGuardAbility)this.sablesGuardWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.stopCooldown((LivingEntity)this));
                ((SablesGuardAbility)this.sablesGuardWrapper.getAbility()).use((LivingEntity)this);
            }
            if (!((HookGrabAbility)this.hookGrabWrapper.getAbility()).isContinuous() && this.kitingMeter.getRevengeValue() > 20) {
                this.kitingMeter.addRevengeValue(-20);
                ((HookGrabAbility)this.hookGrabWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.stopCooldown((LivingEntity)this));
            }
        }
    }

    public void startSecondPhase() {
        this.getPhaseManager().setPhase(this.secondPhase);
    }

    public void startThirdPhase() {
        this.getPhaseManager().setPhase(this.thirdPhase);
    }

    public boolean isFirstPhaseActive() {
        return this.firstPhase.isActive(this);
    }

    public boolean isSecondPhaseActive() {
        return this.secondPhase.isActive(this);
    }

    public boolean isThirdPhaseActive() {
        return this.thirdPhase.isActive(this);
    }

    private void startSecondPhaseEvent(Mr0Entity entity) {
        ModifiableAttributeInstance attr;
        if (this.isDifficultyHardOrAbove() && (attr = entity.func_110148_a((Attribute)ModAttributes.GCD.get())) != null && !attr.func_180374_a(GCD_MOD)) {
            attr.func_233767_b_(GCD_MOD);
        }
    }

    private void startThirdPhaseEvent(Mr0Entity entity) {
        this.groundSeccoAbility.setSizeModifier(2.0f);
    }

    public RevengeMeter getPainMeter() {
        return this.painMeter;
    }
}

