/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.arlongpirates;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.abilities.brawler.ChargedPunchAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.KachiageHaisokuAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.MurasameAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.SamehadaShoteiAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.SharkOnToothAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.UchimizuAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.DeadzoneRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.GankingRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalHitRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.HumanoidSwimMoveController;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FactionHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.TakedownKickWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.PartyTableKickCourseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.KachiageHaisokuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.MurasameWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.SamehadaShoteiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.SharkOnToothWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.UchimizuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ArlongEntity
extends OPBossEntity<ArlongEntity> {
    private static final UUID STANDARD_UCHIMIZU_COOLDOWN_UUID = UUID.fromString("efa25144-6946-48c2-8e2a-cb2135b98783");
    private static final UUID HARD_MURASAME_COOLDOWN_UUID = UUID.fromString("08737d15-31f0-4103-b09a-99cd98e72cda");
    private static final UUID WATER_UCHIMIZU_COOLDOWN_UUID = UUID.fromString("55220e18-d068-4913-9cf5-ba7c57eeeb4e");
    private static final UUID WATER_SHARK_ON_TOOTH_COOLDOWN_UUID = UUID.fromString("c5c03564-411b-4a21-85e9-e9b003c91123");
    private static final AttributeModifier GCD_MOD = new AttributeModifier(UUID.fromString("e478aceb-9865-40da-a137-6359ba503bf0"), "GCD Modifier", -5.0, AttributeModifier.Operation.ADDITION);
    private RevengeMeter revengeMeter;
    private float revengeThreshold;
    private MovementController groundMovementController;
    private MovementController waterMovementController;
    private NPCPhase<ArlongEntity> firstPhase;
    private NPCPhase<ArlongEntity> secondPhase;
    private NPCPhase<ArlongEntity> waterPhase;
    private Optional<CooldownComponent> uchimizuCooldownComponent;
    private SharkOnToothWrapperGoal sharkOnToothWrapper;
    private Optional<CooldownComponent> sharkOnToothCooldownComponent;

    public ArlongEntity(EntityType type, World world) {
        super(type, world);
    }

    public ArlongEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.ARLONG.get(), challenge);
        this.revengeThreshold = challenge.isStandardDifficulty() ? 0.5f : 0.3f;
    }

    @Override
    public void initBoss() {
        this.revengeMeter = new RevengeMeter((LivingEntity)this, 100, 1);
        this.groundMovementController = new MovementController((MobEntity)this);
        this.waterMovementController = new HumanoidSwimMoveController((MobEntity)this);
        this.firstPhase = new SimplePhase<ArlongEntity>("First Phase", this);
        this.secondPhase = new SimplePhase<ArlongEntity>("Second Phase", this, this::startSecondPhaseEvent);
        this.waterPhase = new SimplePhase<ArlongEntity>("Water Phase", this, this::startWaterPhaseEvent, this::stopWaterPhaseEvent);
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.FISHMAN);
        this.entityStats.setFightingStyle(ModValues.BRAWLER);
        ExtendedWorldData worldData = ExtendedWorldData.get();
        worldData.addTemporaryCrewMember(ModNPCGroups.ARLONG_PIRATES, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        this.getRevengeMeter().addCheck(new PhysicalHitRevengeCheck(1));
        this.getRevengeMeter().addCheck(new GankingRevengeCheck(5, 5.0f));
        UchimizuWrapperGoal uchimizuWrapper = new UchimizuWrapperGoal((MobEntity)this);
        Optional<CooldownComponent> cooldownComponent = ((UchimizuAbility)uchimizuWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN);
        cooldownComponent.ifPresent(comp -> {
            comp.getBonusManager().addBonus(STANDARD_UCHIMIZU_COOLDOWN_UUID, "Standard Uchimizu Bonus", BonusOperation.MUL, 2.0f);
            comp.startCooldown((LivingEntity)this, 120.0f);
        });
        KachiageHaisokuWrapperGoal kachiageWrapper = new KachiageHaisokuWrapperGoal((MobEntity)this);
        ((KachiageHaisokuAbility)kachiageWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            ChargedPunchAbility abl = AbilityDataCapability.get(entity).getEquippedAbility(ChargedPunchAbility.INSTANCE);
            if (abl != null && abl.isCharging()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        ChargedPunchWrapperGoal chargedPunchWrapper = new ChargedPunchWrapperGoal((MobEntity)this);
        ((ChargedPunchAbility)chargedPunchWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            KachiageHaisokuAbility abl = AbilityDataCapability.get(entity).getEquippedAbility(KachiageHaisokuAbility.INSTANCE);
            if (abl != null && abl.isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        SamehadaShoteiWrapperGoal samehadaWrapper = new SamehadaShoteiWrapperGoal((MobEntity)this);
        ((SamehadaShoteiAbility)samehadaWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            SharkOnToothAbility abl = AbilityDataCapability.get(entity).getEquippedAbility(SharkOnToothAbility.INSTANCE);
            if (abl != null && abl.isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        this.sharkOnToothWrapper = new SharkOnToothWrapperGoal((MobEntity)this);
        this.sharkOnToothCooldownComponent = ((SharkOnToothAbility)this.sharkOnToothWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN);
        this.uchimizuCooldownComponent = ((UchimizuAbility)uchimizuWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN);
        SharkOnToothAbility sharkOnToothAbility = (SharkOnToothAbility)this.sharkOnToothWrapper.getAbility();
        sharkOnToothAbility.addCanUseCheck((entity, ability) -> {
            LivingEntity target = this.func_70638_az();
            if (this.waterPhase.isActive(this) && target != null) {
                if (EntityStatsCapability.get(target).isFishman()) {
                    return AbilityUseResult.success();
                }
                if (target.func_226278_cu_() - this.func_226278_cu_() <= 2.0) {
                    return AbilityUseResult.fail(null);
                }
            }
            return AbilityUseResult.success();
        });
        sharkOnToothAbility.addTickEvent((entity, ability) -> {
            LivingEntity target;
            if (this.waterPhase.isActive(this) && sharkOnToothAbility.isContinuous() && sharkOnToothAbility.hasHitTarget() && (target = sharkOnToothAbility.getComponent(ModAbilityKeys.DAMAGE).get().getLastTarget()) != null) {
                sharkOnToothAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().stopContinuity((LivingEntity)this);
                sharkOnToothAbility.getComponent(ModAbilityKeys.ANIMATION).get().start((LivingEntity)this, ModAnimations.TAKEDOWN_KICK, 7);
                AbilityHelper.setDeltaMovement((Entity)target, entity.func_213322_ci().field_72450_a, -5.0, entity.func_213322_ci().field_72449_c);
            }
        });
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        Predicate<Entity> factionScope = ModEntityPredicates.getEnemyFactions((LivingEntity)this).and(ModEntityPredicates.IS_ENTITY_HARMLESS.negate());
        Predicate<Entity> invisibleCheck = factionScope.and(ModEntityPredicates.IS_INVISIBLE.negate());
        this.field_70715_bh.func_75776_a(1, (Goal)new FactionHurtByTargetGoal(this, factionScope, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, true, invisibleCheck));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, true, invisibleCheck));
        this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<FishmanPassiveBonusesAbility>((MobEntity)this, FishmanPassiveBonusesAbility.INSTANCE));
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.firstPhase.addGoal(1, new SprintTowardsTargetGoal((MobEntity)this));
        this.firstPhase.addGoal(3, uchimizuWrapper);
        this.firstPhase.addGoal(3, new TakedownKickWrapperGoal((MobEntity)this));
        this.firstPhase.addGoal(4, chargedPunchWrapper);
        this.firstPhase.addGoal(4, samehadaWrapper);
        this.firstPhase.addGoal(4, kachiageWrapper);
        this.firstPhase.addGoal(4, this.sharkOnToothWrapper);
        this.secondPhase.addGoal(1, new SprintTowardsTargetGoal((MobEntity)this));
        this.secondPhase.addGoal(3, uchimizuWrapper);
        this.secondPhase.addGoal(3, new TakedownKickWrapperGoal((MobEntity)this));
        this.secondPhase.addGoal(4, samehadaWrapper);
        this.secondPhase.addGoal(4, kachiageWrapper);
        this.secondPhase.addGoal(4, this.sharkOnToothWrapper);
        this.waterPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 100.0f, 5.0f));
        this.waterPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 70.0f, 2.25f));
        this.waterPhase.addGoal(3, uchimizuWrapper);
        this.waterPhase.addGoal(4, this.sharkOnToothWrapper);
        this.getPhaseManager().setPhase(this.firstPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(2.0);
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
            this.getRevengeMeter().addCheck(new DeadzoneRevengeCheck(5));
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(5.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(5.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(8.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(400.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(5.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
            this.getRevengeMeter().addCheck(new DeadzoneRevengeCheck(10));
            MurasameWrapperGoal murasameWrapper = new MurasameWrapperGoal((MobEntity)this);
            Optional<CooldownComponent> murasameCooldownComponent = ((MurasameAbility)murasameWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN);
            murasameCooldownComponent.ifPresent(comp -> {
                comp.getBonusManager().addBonus(HARD_MURASAME_COOLDOWN_UUID, "Murasame Cooldown Bonus", BonusOperation.ADD, -200.0f);
                comp.startCooldown((LivingEntity)this, 100.0f);
            });
            Optional<CooldownComponent> uchimizuCooldownComponent = ((UchimizuAbility)uchimizuWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN);
            uchimizuCooldownComponent.ifPresent(comp -> comp.getBonusManager().removeBonus(STANDARD_UCHIMIZU_COOLDOWN_UUID));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)murasameWrapper);
            this.firstPhase.addGoal(3, new PartyTableKickCourseWrapperGoal((MobEntity)this));
            this.secondPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 120.0f, 5.0f));
            this.secondPhase.addGoal(3, new PartyTableKickCourseWrapperGoal((MobEntity)this));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233820_c_, 0.2);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.getRevengeMeter().tick();
            if (this.secondPhase.isActive(this) && this.getRevengeMeter().getRevengePercentage() > this.revengeThreshold && this.sharkOnToothCooldownComponent.isPresent() && this.sharkOnToothCooldownComponent.get().isOnCooldown()) {
                this.sharkOnToothCooldownComponent.get().stopCooldown((LivingEntity)this);
                this.getRevengeMeter().reduceRevengeValue(25);
            }
            if (this.func_70090_H()) {
                this.getPhaseManager().setPhase(this.waterPhase);
            } else if (this.waterPhase.isActive(this) && this.getPhaseManager().getPreviousPhase() != null) {
                this.getPhaseManager().setPhase(this.getPhaseManager().getPreviousPhase());
            } else if (this.firstPhase.isActive(this) && (double)this.func_110143_aJ() <= WyHelper.percentage(50.0, this.func_110138_aP())) {
                this.getPhaseManager().setPhase(this.secondPhase);
            } else if (!this.secondPhase.isActive(this)) {
                this.getPhaseManager().setPhase(this.firstPhase);
            }
        }
    }

    private void startSecondPhaseEvent(ArlongEntity entity) {
        ModifiableAttributeInstance attr;
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.KIRIBACHI.get()));
        this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(1.0);
        if (this.isDifficultyHardOrAbove() && (attr = entity.func_110148_a((Attribute)ModAttributes.GCD.get())) != null && !attr.func_180374_a(GCD_MOD)) {
            attr.func_233767_b_(GCD_MOD);
        }
    }

    private void startWaterPhaseEvent(ArlongEntity entity) {
        this.field_70765_h = this.waterMovementController;
        this.uchimizuCooldownComponent.ifPresent(comp -> {
            if (!comp.getBonusManager().hasBonus(WATER_UCHIMIZU_COOLDOWN_UUID)) {
                comp.getBonusManager().addBonus(WATER_UCHIMIZU_COOLDOWN_UUID, "Uchimizu Cooldown Water Bonus", BonusOperation.MUL, 0.5f);
            }
        });
        this.sharkOnToothCooldownComponent.ifPresent(comp -> {
            if (!comp.getBonusManager().hasBonus(WATER_SHARK_ON_TOOTH_COOLDOWN_UUID)) {
                comp.getBonusManager().addBonus(WATER_SHARK_ON_TOOTH_COOLDOWN_UUID, "Shark on Tooth Cooldown Water Bonus", BonusOperation.MUL, 0.5f);
            }
        });
        this.sharkOnToothWrapper.setMaxDistance(50.0);
    }

    private void stopWaterPhaseEvent(ArlongEntity entity) {
        this.field_70765_h = this.groundMovementController;
        this.uchimizuCooldownComponent.ifPresent(comp -> comp.getBonusManager().removeBonus(WATER_UCHIMIZU_COOLDOWN_UUID));
        this.sharkOnToothCooldownComponent.ifPresent(comp -> comp.getBonusManager().removeBonus(WATER_SHARK_ON_TOOTH_COOLDOWN_UUID));
        this.sharkOnToothWrapper.setMaxDistance(10.0);
    }

    @Override
    public RevengeMeter getRevengeMeter() {
        return this.revengeMeter;
    }
}

