/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.dugong;

import java.util.EnumSet;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.AbstractDugongEntity;
import xyz.pixelatedw.mineminenomi.init.ModMemoryModuleTypes;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DugongRestGoal
extends TickedGoal<AbstractDugongEntity> {
    private Interval canUseInterval = new Interval(40);
    private Interval sleepBubbleTimer = new Interval(50);
    private int restTime;
    private int nextRestTime = 2;
    private float startHealth;
    private float startYaw;

    public DugongRestGoal(AbstractDugongEntity entity) {
        super(entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.canUseInterval.canTick()) {
            return false;
        }
        if (!((AbstractDugongEntity)this.entity).isIdling()) {
            return false;
        }
        if (((AbstractDugongEntity)this.entity).hasMemoryValue((MemoryModuleType)ModMemoryModuleTypes.LAST_EXPLOSION_HEARD.get())) {
            return false;
        }
        if (this.getLastEndTick() <= 0L) {
            this.setLastEndTick(((AbstractDugongEntity)this.entity).field_70170_p.func_82737_E());
        }
        if (!this.hasTimePassedSinceLastEnd(WyHelper.minutesToTicks(this.nextRestTime))) {
            return false;
        }
        return !GoalUtil.hasAliveTarget(this.entity);
    }

    public boolean func_75253_b() {
        if (((AbstractDugongEntity)this.entity).isEnraged()) {
            return false;
        }
        if (((AbstractDugongEntity)this.entity).isCheering()) {
            return false;
        }
        if (!((AbstractDugongEntity)this.entity).func_70608_bn()) {
            return false;
        }
        if (((AbstractDugongEntity)this.entity).hasMemoryValue((MemoryModuleType)ModMemoryModuleTypes.LAST_EXPLOSION_HEARD.get())) {
            return false;
        }
        if (((AbstractDugongEntity)this.entity).func_110143_aJ() < this.startHealth) {
            return false;
        }
        if (GoalUtil.shouldMove(this.entity)) {
            return false;
        }
        if (GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        return !this.hasTimePassedSinceStart(WyHelper.secondsToTicks(this.restTime));
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        ((AbstractDugongEntity)this.entity).setResting(true);
        this.restTime = 20 + ((AbstractDugongEntity)this.entity).func_70681_au().nextInt(20);
        this.nextRestTime = 2 + ((AbstractDugongEntity)this.entity).func_70681_au().nextInt(3);
        ((AbstractDugongEntity)this.entity).func_70661_as().func_75499_g();
        this.startHealth = ((AbstractDugongEntity)this.entity).func_110143_aJ();
        this.startYaw = ((AbstractDugongEntity)this.entity).field_70761_aq;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.sleepBubbleTimer.canTick()) {
            Vector3d look = ((AbstractDugongEntity)this.entity).func_70040_Z().func_186678_a(0.75);
            SimpleParticleData part = new SimpleParticleData((ParticleType)ModParticleTypes.AWA.get());
            part.setLife(20);
            part.setSize(2.0f);
            part.setHasScaleDecay(false);
            WyHelper.spawnParticles(part, (ServerWorld)((AbstractDugongEntity)this.entity).field_70170_p, ((AbstractDugongEntity)this.entity).func_226277_ct_() + look.field_72450_a, ((AbstractDugongEntity)this.entity).func_226280_cw_() + look.field_72448_b - 0.85, ((AbstractDugongEntity)this.entity).func_226281_cx_() + look.field_72449_c);
        }
        this.startYaw = ((AbstractDugongEntity)this.entity).field_70761_aq;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        ((AbstractDugongEntity)this.entity).setResting(false);
    }
}

