/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.MurasameAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.UchimizuAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MurasameWrapperGoal
extends AbilityWrapperGoal<MobEntity, MurasameAbility> {
    private LivingEntity target;
    private double minDistance = 10.0;
    private double maxDistance = ((MurasameAbility)this.getAbility()).getComponent(ModAbilityKeys.PROJECTILE).flatMap(comp -> Optional.ofNullable(((AbilityProjectileEntity)((Object)((Object)comp.getNewProjectile((LivingEntity)entity)))).getMaxLife())).orElse(30).intValue();

    public MurasameWrapperGoal(MobEntity entity) {
        super(entity, MurasameAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.minDistance)) {
            return false;
        }
        if (GoalUtil.isOutsideDistance((LivingEntity)this.entity, this.target, this.maxDistance)) {
            return false;
        }
        if (!GoalUtil.canSee(this.entity, this.target)) {
            return false;
        }
        UchimizuAbility uchimizuAbility = this.getProps().getEquippedAbility(UchimizuAbility.INSTANCE);
        if (uchimizuAbility != null) {
            boolean cooldownCheck;
            Optional<CooldownComponent> comp = uchimizuAbility.getComponent(ModAbilityKeys.COOLDOWN);
            boolean bl = cooldownCheck = comp.isPresent() && (double)comp.get().getCooldown() > WyHelper.percentage(75.0, comp.get().getStartCooldown());
            if (uchimizuAbility.isContinuous() || cooldownCheck) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return ((MurasameAbility)this.getAbility()).isContinuous();
    }

    @Override
    public void startWrapper() {
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void tickWrapper() {
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void stopWrapper() {
    }
}

