/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.doru;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.abilities.doru.CandleWallAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CandleWallWrapperGoal
extends AbilityWrapperGoal<MobEntity, CandleWallAbility> {
    private static final float CHECK_AREA = 40.0f;
    private ProjectileEntity projectileTarget;
    private int hits;
    private int triggerHits = 3;
    private double previousDistance = 0.0;

    public CandleWallWrapperGoal(MobEntity entity) {
        super(entity, CandleWallAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        boolean isOnCooldown = ((CandleWallAbility)this.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).map(CooldownComponent::isOnCooldown).orElse(false);
        if (isOnCooldown) {
            return false;
        }
        List<ProjectileEntity> projectiles = WyHelper.getNearbyEntities(this.entity.func_213303_ch(), (IWorld)this.entity.field_70170_p, 40.0, null, ProjectileEntity.class);
        for (ProjectileEntity proj : projectiles) {
            boolean isEnemyProjectile = ModEntityPredicates.getEnemyFactions((LivingEntity)this.entity).test(proj.func_234616_v_());
            if (!isEnemyProjectile) continue;
            this.projectileTarget = proj;
            double distance = proj.func_70068_e((Entity)this.entity);
            if (this.previousDistance == 0.0) {
                this.previousDistance = distance;
            }
            if (!(distance < this.previousDistance)) break;
            ++this.hits;
            this.previousDistance = distance;
            break;
        }
        return this.hits >= this.triggerHits;
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return false;
    }

    @Override
    public void startWrapper() {
        GoalUtil.lookAtEntity(this.entity, (Entity)this.projectileTarget);
    }

    @Override
    public void tickWrapper() {
    }

    @Override
    public void stopWrapper() {
        this.hits = 0;
    }
}

