/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.abilities.ShakushiAbility;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeInfo;
import xyz.pixelatedw.mineminenomi.api.challenges.IChallengeBoss;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class ShakushiWrapperGoal
extends AbilityWrapperGoal<MobEntity, ShakushiAbility> {
    private float minDistance = ((ShakushiAbility)this.getAbility()).getComponent(ModAbilityKeys.RANGE).map(comp -> Float.valueOf(comp.getRange())).orElse(Float.valueOf(10.0f)).floatValue();

    public ShakushiWrapperGoal(MobEntity entity) {
        super(entity, ShakushiAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!GoalUtil.canMove((LivingEntity)this.entity)) {
            return false;
        }
        if (this.entity instanceof IChallengeBoss) {
            ChallengeInfo info = ((IChallengeBoss)this.entity).getChallengeInfo();
            if (info.getChallengerGroup().isEmpty()) {
                return false;
            }
            int id = this.entity.func_70681_au().nextInt(info.getChallengerGroup().size());
            LivingEntity target = info.getChallengerGroup().get(id);
            if (target != null && target.func_70089_S()) {
                Vector3d targetLook = VectorHelper.calculateViewVectorFromBodyRot(target.field_70125_A, target.field_70761_aq).func_216372_d(-2.0, 0.0, -2.0);
                Vector3d newPos = target.func_213303_ch().func_178787_e(targetLook);
                this.entity.func_70634_a(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
            }
        } else if (!GoalUtil.hasEnoughTargetsAround(this.entity, 1, this.minDistance)) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return true;
    }

    @Override
    public void startWrapper() {
    }

    @Override
    public void tickWrapper() {
    }

    @Override
    public void stopWrapper() {
    }
}

