/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;

public class MeleeRangedStyleSwitchGoal
extends TickedGoal<MobEntity> {
    private static final float SWITCH_RANGE = 5.0f;
    private static final int COOLDOWN = 20;
    private boolean isInRangedMode = true;
    private boolean forceMeleeInGroupFights;
    private boolean forceMeleeEmptyHanded;
    private final PriorityEventPool<IStyleSwitchEvent> styleSwitchEvents = new PriorityEventPool();

    public MeleeRangedStyleSwitchGoal(MobEntity entity) {
        super(entity);
    }

    public MeleeRangedStyleSwitchGoal addStyleSwitchEvent(int priority, IStyleSwitchEvent event) {
        this.styleSwitchEvents.addEvent(priority, event);
        return this;
    }

    public MeleeRangedStyleSwitchGoal forceMeleeInGroupFights() {
        this.forceMeleeInGroupFights = true;
        return this;
    }

    public MeleeRangedStyleSwitchGoal forceMeleeEmptyHanded() {
        this.forceMeleeEmptyHanded = true;
        return this;
    }

    public boolean func_75250_a() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!this.hasTimePassedSinceLastEnd(20.0f)) {
            return false;
        }
        LivingEntity target = this.entity.func_70638_az();
        if (this.isInRangedMode) {
            ItemStack heldItem;
            if (this.forceMeleeInGroupFights && GoalUtil.hasEnoughTargetsAround(this.entity, 2, 5.0f)) {
                return true;
            }
            if (this.forceMeleeEmptyHanded && (heldItem = this.entity.func_184614_ca()).func_190926_b()) {
                return true;
            }
            return GoalUtil.isWithinDistance((LivingEntity)this.entity, target, 5.0);
        }
        return GoalUtil.isOutsideDistance((LivingEntity)this.entity, target, 5.0);
    }

    public boolean func_75253_b() {
        return false;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.isInRangedMode = !this.isInRangedMode;
        this.styleSwitchEvents.dispatch(event -> event.change(this.entity, this.isInRangedMode));
    }

    @FunctionalInterface
    public static interface IStyleSwitchEvent {
        public void change(MobEntity var1, boolean var2);
    }
}

