/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.brawler.BrawlerPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.api.entities.ITrainer;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.AbstractDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.DamageAbsorptionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.JishinHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SpinningBrawlWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.SuplexWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.IHakiTrainer;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenQuestChooseScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class LegendaryMasterDugongEntity
extends AbstractDugongEntity
implements ITrainer {
    public LegendaryMasterDugongEntity(EntityType type, World world) {
        super((EntityType<? extends TameableEntity>)type, world);
        if (world != null && !world.field_72995_K) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
            props.setFightingStyle(ModValues.BRAWLER);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(8.0);
            this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
            this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<BrawlerPassiveBonusesAbility>((MobEntity)this, BrawlerPassiveBonusesAbility.INSTANCE));
            this.field_70714_bg.func_75776_a(0, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.2f, true));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true, true));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, OPEntity.class, 10, true, true, entity -> EntityStatsCapability.get(entity).isBandit() || EntityStatsCapability.get(entity).isPirate()));
            WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
            goals.addEntry(() -> new HakaiHoWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new JishinHoWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new ChargedPunchWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new SpinningBrawlWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new SuplexWrapperGoal((MobEntity)this), 1.0f);
            this.field_70714_bg.func_75776_a(2, (Goal)new DamageAbsorptionWrapperGoal((MobEntity)this));
            MobsHelper.getRandomizedGoals((MobEntity)this, 5, goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
            MobsHelper.addBusoshokuHaki((MobEntity)this, 100);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233823_f_, 15.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233818_a_, WyHelper.randomWithRange(100, 120)).func_233815_a_(Attributes.field_233826_i_, 10.0);
    }

    @Override
    public List<QuestId> getAvailableQuests(PlayerEntity player) {
        IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
        ArrayList<QuestId> availableQuests = new ArrayList<QuestId>();
        if (entityProps.isBrawler()) {
            availableQuests.addAll(ModQuests.BRAWLER_TRIALS.stream().map(reg -> reg).collect(Collectors.toList()));
        }
        availableQuests.add(ModQuests.EMPTY_HANDS_TRIAL);
        availableQuests.add(ModQuests.KNOCKDOWN_TRIAL);
        availableQuests.add(ModQuests.TAKEDOWN_TRIAL);
        availableQuests.add(ModQuests.COMMAND_TRIAL);
        return availableQuests;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.FAIL;
        }
        if (player.func_213453_ef()) {
            return super.func_230254_b_(player, hand);
        }
        if (!player.field_70170_p.field_72995_K) {
            WyNetwork.sendTo(new SOpenQuestChooseScreenPacket(this.func_145782_y(), WyHelper.isInCombat((LivingEntity)player)), player);
            if (this instanceof IHakiTrainer) {
                WyNetwork.sendTo(new SSyncHakiDataPacket(player.func_145782_y(), HakiDataCapability.get((LivingEntity)player)), player);
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return null;
    }
}

