/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.ability;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.NightmareSoldierEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FactionHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;

public abstract class CloneEntity
extends CreatureEntity
implements IEntityAdditionalSpawnData {
    @Nullable
    private UUID ownerId;
    @Nullable
    private LivingEntity owner;
    private boolean isTextured;
    private int maxAliveTicks = 200;

    public CloneEntity(EntityType type, World world) {
        super(type, world);
        this.field_70728_aV = 0;
        if (world != null && !world.field_72995_K) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
            props.setHeart(false);
            props.setShadow(true);
            this.func_70031_b(true);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.getOwner() == null) {
            this.func_70106_y();
            return;
        }
        this.func_70604_c(this.getOwner());
        if (this.field_70173_aa >= this.maxAliveTicks) {
            this.func_70106_y();
        }
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.ownerId != null) {
            nbt.func_186854_a("ownerId", this.ownerId);
        }
        nbt.func_74757_a("isTextured", this.isTextured);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("ownerId")) {
            this.ownerId = nbt.func_186857_a("ownerId");
        }
        this.isTextured = nbt.func_74767_n("isTextured");
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179252_a(this.ownerId);
        buffer.writeBoolean(this.isTextured);
    }

    public void readSpawnData(PacketBuffer data) {
        this.ownerId = data.func_179253_g();
        this.isTextured = data.readBoolean();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
        this.ownerId = owner.func_110124_au();
        IEntityStats stats = EntityStatsCapability.get((LivingEntity)this);
        stats.setFaction(EntityStatsCapability.get(owner).getFaction());
        Predicate<Entity> factionScope = ModEntityPredicates.getEnemyFactions((LivingEntity)this);
        Predicate<Entity> notSame = entity -> !(entity instanceof NightmareSoldierEntity);
        if (factionScope != null) {
            this.field_70715_bh.func_75776_a(1, (Goal)new FactionHurtByTargetGoal(this, factionScope, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, true, factionScope.and(notSame)));
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.owner == null && this.ownerId != null) {
            this.owner = this.field_70170_p.func_217371_b(this.ownerId);
        }
        return this.owner;
    }

    public UUID getOwnerUUID() {
        return this.ownerId;
    }

    public void setUseOwnerTexture() {
        this.isTextured = true;
    }

    public boolean isUsingOwnerTexture() {
        return this.isTextured;
    }

    public void setMaxAliveTicks(int ticks) {
        this.maxAliveTicks = ticks;
    }
}

