/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.entities.GoalMemories;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.entities.IGoalMemoriesEntity;
import xyz.pixelatedw.mineminenomi.api.entities.IWithHome;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.IRandomTexture;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public abstract class OPEntity
extends CreatureEntity
implements IRandomTexture,
IEntityAdditionalSpawnData,
IGoalMemoriesEntity,
IWithHome {
    private static final float SPAWNER_DESPAWN_DISTANCE = 40000.0f;
    private static final DataParameter<Boolean> HAS_BUSOSHOKU_HAKI_ACTIVE = EntityDataManager.func_187226_a(OPEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_FULLBODY_HAKI_ACTIVE = EntityDataManager.func_187226_a(OPEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ANIMATION = EntityDataManager.func_187226_a(OPEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final GoalMemories goalMemories = new GoalMemories();
    private ResourceLocation currentTexture = null;
    protected ResourceLocation[] textures;
    protected boolean needsEntityDataUpdate;
    private boolean isSpawnerChild = false;
    private Optional<Vector3d> homePosition = Optional.empty();
    private boolean hasFear = true;
    @Deprecated
    private String crew = "";

    public OPEntity(EntityType type, World world) {
        this(type, world, null);
    }

    public OPEntity(EntityType type, World world, ResourceLocation[] textures) {
        super(type, world);
        this.textures = textures;
        if (world != null && !world.field_72995_K) {
            this.chooseTexture();
            if (this.getCurrentTexture() == null) {
                this.setTexture(this.getDefaultTexture());
            }
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233814_a_(Attributes.field_233823_f_).func_233814_a_(Attributes.field_233825_h_);
    }

    public IEntityStats getEntityStats() {
        return EntityStatsCapability.get((LivingEntity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ANIMATION, (Object)-1);
        this.func_184212_Q().func_187214_a(HAS_BUSOSHOKU_HAKI_ACTIVE, (Object)false);
        this.func_184212_Q().func_187214_a(HAS_FULLBODY_HAKI_ACTIVE, (Object)false);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a("texture", this.getCurrentTexture().toString());
        nbt.func_74757_a("hasBusoHaki", this.hasBusoHaki());
        nbt.func_74757_a("hasFullbodyHaki", this.hasFullbodyHaki());
        nbt.func_74757_a("hasFear", this.hasFear);
        nbt.func_74778_a("crew", this.getCrew());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setTexture(new ResourceLocation(nbt.func_74779_i("texture")));
        if (Strings.isNullOrEmpty((String)this.getCurrentTexture().func_110623_a())) {
            this.chooseTexture();
        } else if (!this.getCurrentTexture().func_110623_a().contains("/")) {
            this.chooseTexture();
        }
        this.setBusoHaki(nbt.func_74767_n("hasBusoHaki"));
        this.setFullbodyHaki(nbt.func_74767_n("hasFullbodyHaki"));
        this.hasFear = nbt.func_74767_n("hasFear");
        this.setCrew(nbt.func_74779_i("crew"));
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        if (this.textures != null) {
            return this.textures[0];
        }
        return ModResources.NULL_ENTITY_TEXTURE;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        this.func_184641_n(false);
        if (dataTag != null && dataTag.func_74764_b("isSpawned")) {
            this.isSpawnerChild = true;
        }
        this.homePosition = Optional.of(this.func_213303_ch());
        return spawnData;
    }

    public void func_70636_d() {
        ICommandReceiver receiver;
        this.func_82168_bl();
        super.func_70636_d();
        if (this instanceof ICommandReceiver && !(receiver = (ICommandReceiver)((Object)this)).canMaintainCommand()) {
            receiver.setCurrentCommand(null, NPCCommand.IDLE);
        }
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public static boolean checkSpawnRules(EntityType<? extends OPEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        if (reason == SpawnReason.SPAWNER) {
            return true;
        }
        if (world.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        if (world.func_242415_f(0.0f) > 0.25f && world.func_242415_f(0.0f) < 0.8f) {
            return false;
        }
        if (!world.func_226660_f_(pos)) {
            return false;
        }
        if (pos.func_177956_o() > 150) {
            return false;
        }
        boolean isValidSpawn = world.func_180495_p(pos.func_177977_b()).func_215688_a((IBlockReader)world, pos.func_177977_b(), type);
        return isValidSpawn;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return super.func_213380_a(world, reason);
    }

    public boolean func_213397_c(double distance) {
        return this.isSpawnedViaSpawner() && distance > 40000.0;
    }

    public boolean func_70648_aU() {
        return EntityStatsCapability.get((LivingEntity)this).isFishman();
    }

    public boolean isSpawnedViaSpawner() {
        return this.isSpawnerChild;
    }

    @Override
    public Optional<Vector3d> getHomePosition() {
        return this.homePosition;
    }

    @Override
    public ResourceLocation getCurrentTexture() {
        return this.currentTexture;
    }

    protected void setTexture(ResourceLocation id) {
        this.currentTexture = id;
    }

    public void setTextures(ResourceLocation[] textures) {
        this.textures = textures;
    }

    public void chooseTexture() {
        this.chooseTexture(this.field_70146_Z);
    }

    public void chooseTexture(Random random) {
        if (this.textures != null && this.textures.length > 0) {
            int id = random.nextInt(this.textures.length);
            this.setTexture(this.textures[id]);
        }
    }

    public void setFear(boolean flag) {
        this.hasFear = flag;
    }

    public boolean hasFear() {
        return this.hasFear;
    }

    public double getDoriki() {
        return this.getEntityStats().getDoriki();
    }

    public void setDoriki(double value) {
        this.getEntityStats().setDoriki((int)Math.floor(value));
        this.field_70728_aV = (int)(this.getDoriki() / 100.0);
    }

    public long getBelly() {
        return this.getEntityStats().getBelly();
    }

    public void setBelly(double value) {
        this.getEntityStats().setBelly((long)value);
    }

    @Deprecated
    public int getAnimation() {
        return (Integer)this.field_70180_af.func_187225_a(ANIMATION);
    }

    @Deprecated
    public void setAnimation(int value) {
        this.field_70180_af.func_187227_b(ANIMATION, (Object)value);
    }

    @Deprecated
    public boolean hasBusoHaki() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BUSOSHOKU_HAKI_ACTIVE);
    }

    @Deprecated
    public void setBusoHaki(boolean value) {
        this.field_70180_af.func_187227_b(HAS_BUSOSHOKU_HAKI_ACTIVE, (Object)value);
    }

    @Deprecated
    public boolean hasFullbodyHaki() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_FULLBODY_HAKI_ACTIVE);
    }

    @Deprecated
    public void setFullbodyHaki(boolean value) {
        this.func_184212_Q().func_187227_b(HAS_FULLBODY_HAKI_ACTIVE, (Object)value);
    }

    public void queueEntityDataUpdate() {
        this.needsEntityDataUpdate = true;
    }

    @Deprecated
    public String getCrew() {
        return this.crew;
    }

    @Deprecated
    public void setCrew(String crew) {
        this.crew = crew;
    }

    public ItemStack getRandomSword(List<Supplier<? extends Item>> list) {
        return this.getRandomSword(this.field_70146_Z, list);
    }

    public ItemStack getRandomSword(Random random, List<Supplier<? extends Item>> list) {
        return new ItemStack((IItemProvider)list.get(random.nextInt(list.size())).get());
    }

    public boolean isAboveNormalDifficulty() {
        return this.field_70170_p.func_175659_aa().func_151525_a() > Difficulty.NORMAL.func_151525_a();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70725_aQ > 0 && this.func_110143_aJ() > 0.0f) {
            this.field_70725_aQ = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184187_bx() instanceof BoatEntity && this.func_70638_az() != null) {
                this.func_184210_p();
            }
            if (this.needsEntityDataUpdate) {
                WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(this.func_145782_y(), this.getEntityStats()), (Entity)this);
                this.needsEntityDataUpdate = false;
            }
        }
    }

    public void func_70619_bc() {
        this.goalMemories.tick();
    }

    public double func_70033_W() {
        return -0.35;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        int len = this.currentTexture.toString().length();
        buffer.writeInt(len);
        buffer.func_211400_a(this.currentTexture.toString(), len);
    }

    public void readSpawnData(PacketBuffer buffer) {
        int len = buffer.readInt();
        this.currentTexture = new ResourceLocation(buffer.func_150789_c(len));
    }

    @Override
    public GoalMemories getGoalMemories() {
        return this.goalMemories;
    }

    @Deprecated
    public static enum Animation implements IExtensibleEnum
    {
        NONE(0),
        FLINTLOCK_POINTING(1),
        CLEAVE_ATTACK(2),
        SHOCKWAVE(3),
        BLOCK(4);

        private int id;

        private Animation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Animation create(String name, int id) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

