/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.BrawlerPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.GapCloserGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.KnifeThrowingGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CaptainEntity
extends OPEntity
implements IRangedAttackMob,
ICommandReceiver {
    private static final ResourceLocation[] STYLES = new ResourceLocation[]{ModValues.SWORDSMAN, ModValues.BRAWLER};
    private static final Map<ResourceLocation, ArrayList<Supplier<? extends Item>>> MELEE_FACTION_WEAPONS = CaptainEntity.createFactionWeaponsMap();
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;

    private static Map<ResourceLocation, ArrayList<Supplier<? extends Item>>> createFactionWeaponsMap() {
        HashMap<ResourceLocation, ArrayList<Supplier<? extends Item>>> map = new HashMap<ResourceLocation, ArrayList<Supplier<? extends Item>>>();
        map.put(ModValues.PIRATE, MobsHelper.PIRATE_SWORDS);
        map.put(ModValues.MARINE, MobsHelper.MARINE_CAPTAIN_SWORDS);
        map.put(ModValues.BANDIT, MobsHelper.BANDIT_SWORDS);
        return map;
    }

    public CaptainEntity(EntityType type, World world, ResourceLocation faction) {
        super(type, world, null);
        ResourceLocation style = STYLES[this.func_70681_au().nextInt(STYLES.length)];
        if (world != null && !world.field_72995_K) {
            this.getEntityStats().setFaction(faction);
            this.getEntityStats().setFightingStyle(style);
            this.getEntityStats().setRace(ModValues.HUMAN);
            this.setDetails();
            if (this.field_70146_Z.nextFloat() < 0.7f) {
                if (this.field_70146_Z.nextFloat() < 0.3f) {
                    this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.THREE_CIGARS.get()));
                } else {
                    this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.CIGAR.get()));
                }
            }
            boolean isHardDifficulty = this.isAboveNormalDifficulty();
            this.setDoriki(3000.0 + WyHelper.randomWithRange(0, 2000) + (isHardDifficulty ? WyHelper.randomWithRange(0, 500) : 0.0));
            this.setBelly(30.0 + WyHelper.randomWithRange(0, 20));
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(6.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            int rokushikiAbilities = this.getEntityStats().isBandit() ? 2 : 3;
            MobsHelper.addBasicNPCGoals(this);
            CommandAbility.addCommandGoals((MobEntity)this);
            this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new GapCloserGoal((MobEntity)this));
            if (this.field_70146_Z.nextFloat() < 0.6f) {
                this.field_70714_bg.func_75776_a(0, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
            }
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
            if (this.getEntityStats().isBandit()) {
                this.field_70714_bg.func_75776_a(2, (Goal)new KnifeThrowingGoal(this).setAmount(3));
            }
            MobsHelper.addRokushikiAbilities((MobEntity)this, rokushikiAbilities);
            MobsHelper.addBusoshokuHaki((MobEntity)this, 30);
        }
    }

    public static CaptainEntity createMarineCaptain(EntityType type, World world) {
        return new CaptainEntity(type, world, ModValues.MARINE);
    }

    public static CaptainEntity createPirateCaptain(EntityType type, World world) {
        return new CaptainEntity(type, world, ModValues.PIRATE);
    }

    public static CaptainEntity createBanditCaptain(EntityType type, World world) {
        return new CaptainEntity(type, world, ModValues.BANDIT);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, WyHelper.randomWithRange(3, 6)).func_233815_a_(Attributes.field_233818_a_, WyHelper.randomWithRange(100, 150)).func_233815_a_(Attributes.field_233826_i_, WyHelper.randomWithRange(8, 12));
    }

    public void func_82196_d(LivingEntity target, float velocity) {
        if (this.func_184614_ca() == null || !this.func_184614_ca().func_77973_b().equals(ModWeapons.BAZOOKA.get())) {
            return;
        }
        CannonBallProjectile proj = new CannonBallProjectile(this.field_70170_p, (LivingEntity)this);
        proj.setDamage(3.0f);
        proj.onBlockImpactEvent = hit -> {
            if (this.field_70173_aa < 2) {
                return;
            }
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)proj, this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 2.0f);
            explosion.setStaticDamage(5.0f);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.doExplosion();
        };
        double velX = target.func_226277_ct_() - this.func_226277_ct_();
        double velY = target.func_174813_aQ().field_72338_b - proj.func_226278_cu_();
        double velZ = target.func_226281_cx_() - this.func_226281_cx_();
        double x = MathHelper.func_76133_a((double)(velX * velX + velZ * velZ));
        proj.func_70186_c(velX, velY + x * (double)0.1f, velZ, 2.0f, MathHelper.func_76125_a((int)(12 - this.field_70170_p.func_175659_aa().func_151525_a() * 4), (int)0, (int)100));
        this.field_70170_p.func_217376_c((Entity)proj);
    }

    protected boolean func_225511_J_() {
        return true;
    }

    private void setDetails() {
        IEntityStats props = this.getEntityStats();
        if (props.isPirate()) {
            this.setPirateDetails();
        } else if (props.isMarine()) {
            this.setMarineDetails();
        } else if (props.isBandit()) {
            this.setBanditDetails();
        }
        this.chooseTexture();
        if (props.isSwordsman()) {
            this.setSwordsmanDetails();
        } else if (props.isBrawler()) {
            this.setBrawlerDetails();
        }
    }

    private void setSwordsmanDetails() {
        float dualWeildChance;
        ItemStack randomSword = this.getRandomSword((List<Supplier<? extends Item>>)MELEE_FACTION_WEAPONS.get(this.getEntityStats().getFaction()));
        this.func_184201_a(EquipmentSlotType.MAINHAND, randomSword);
        float f = dualWeildChance = this.getEntityStats().isPirate() ? 0.4f : 0.2f;
        if (this.field_70146_Z.nextFloat() < dualWeildChance) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, randomSword.func_77946_l());
        }
        int swordsmanAbilities = this.getEntityStats().isBandit() ? 3 : 2;
        MobsHelper.addSwordsmanAbilities((MobEntity)this, swordsmanAbilities);
    }

    private void setBrawlerDetails() {
        this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<BrawlerPassiveBonusesAbility>((MobEntity)this, BrawlerPassiveBonusesAbility.INSTANCE));
        int brawlerAbilities = this.getEntityStats().isBandit() ? 3 : 3;
        MobsHelper.addBrawlerAbilities((MobEntity)this, brawlerAbilities);
        this.field_70714_bg.func_75776_a(3, (Goal)new ChargedPunchWrapperGoal((MobEntity)this));
    }

    private void setMarineDetails() {
        this.setTextures(MobsHelper.MARINE_CAPTAINS_TEXTURES);
        ItemStack marineCapeStack = new ItemStack((IItemProvider)ModArmors.MARINE_CAPTAIN_CAPE.get());
        marineCapeStack.func_190925_c("display").func_74768_a("color", MobsHelper.MARINE_BLUE_COLOR.getRGB());
        this.func_184201_a(EquipmentSlotType.CHEST, marineCapeStack);
    }

    private void setPirateDetails() {
        this.setTextures(MobsHelper.PIRATE_CAPTAINS_TEXTURES);
        if (this.field_70146_Z.nextFloat() < 0.4f) {
            ItemStack pirateCapeStack = new ItemStack((IItemProvider)ModArmors.PIRATE_CAPTAIN_CAPE.get());
            this.func_184201_a(EquipmentSlotType.CHEST, pirateCapeStack);
        }
    }

    private void setBanditDetails() {
        this.setTextures(MobsHelper.BANDIT_TEXTURES);
    }

    @Override
    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        if (!this.getEntityStats().isMarine()) {
            return false;
        }
        IEntityStats senderProps = EntityStatsCapability.get(commandSender);
        if (!senderProps.isMarine()) {
            return false;
        }
        return senderProps.hasMarineRank(FactionHelper.MarineRank.ADMIRAL);
    }

    @Override
    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    @Override
    public boolean canMaintainCommand() {
        return this.lastCommandSender == null || !this.lastCommandSender.func_70089_S() || !EntityStatsCapability.get(this.lastCommandSender).isRogue();
    }

    @Override
    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Override
    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    @Override
    public long getLastCommandTime() {
        return this.lastCommandTime;
    }

    public static boolean checkSpawnRules(EntityType<? extends OPEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        double chance = random.nextDouble() * 100.0;
        if (chance > CommonConfig.INSTANCE.getCaptainSpawnChance()) {
            return false;
        }
        return OPEntity.checkSpawnRules(type, world, reason, pos, random);
    }
}

