/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.HookGrabAbility;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.ExtraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HookEntity
extends AbilityProjectileEntity {
    private IDevilFruit props;

    public HookEntity(EntityType type, World world) {
        super(type, world);
    }

    public HookEntity(World world, LivingEntity thrower) {
        super((EntityType)ExtraProjectiles.HOOK.get(), world, thrower, HookGrabAbility.INSTANCE);
        this.setMaxLife(50);
        this.setEntityCollisionSize(1.0);
        this.props = DevilFruitCapability.get(thrower);
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                SimpleParticleData part = null;
                if (this.props.hasDevilFruit(ModAbilities.SUNA_SUNA_NO_MI)) {
                    part = new SimpleParticleData((ParticleType)ModParticleTypes.SUNA2.get());
                    part.setSize(1.5f);
                } else if (this.props.hasDevilFruit(ModAbilities.MOKU_MOKU_NO_MI)) {
                    part = new SimpleParticleData((ParticleType)ModParticleTypes.MOKU.get());
                    part.setSize(1.3f);
                }
                if (part == null) continue;
                part.setLife(20);
                part.setRotation(0.0f, 0.0f, 1.0f);
                WyHelper.spawnParticles(part, (ServerWorld)this.field_70170_p, super.func_226277_ct_() + offsetX, super.func_226278_cu_() + offsetY, super.func_226281_cx_() + offsetZ);
            }
        }
    }
}

